/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity.display;

import java.util.Objects;
import me.moros.bending.api.platform.entity.display.AbstractDisplayBuilder;
import me.moros.bending.api.platform.entity.display.TextDisplay;
import me.moros.bending.api.platform.entity.display.TextDisplayImpl;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.RGBLike;

public final class TextDisplayBuilder
extends AbstractDisplayBuilder<Component, TextDisplayBuilder> {
    private int lineWidth = 200;
    private int backgroundColor = 0x40000000;
    private byte opacity = (byte)-1;
    private boolean hasShadow = false;
    private boolean isSeeThrough = false;
    private boolean hasDefaultBackground = false;
    private TextDisplay.Alignment alignment = TextDisplay.Alignment.CENTER;

    TextDisplayBuilder() {
        super(TextDisplayImpl::new);
    }

    TextDisplayBuilder(TextDisplay display) {
        super(TextDisplayImpl::new, display);
        this.lineWidth(display.lineWidth());
        this.backgroundColor(display.backgroundColor());
        this.opacity(display.opacity());
        this.hasShadow(display.textFlags().hasShadow());
        this.isSeeThrough(display.textFlags().isSeeThrough());
        this.hasDefaultBackground(display.textFlags().hasDefaultBackground());
        this.alignment(display.textFlags().alignment());
    }

    public int lineWidth() {
        return this.lineWidth;
    }

    public TextDisplayBuilder lineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public int backgroundColor() {
        return this.backgroundColor;
    }

    public TextDisplayBuilder backgroundColor(RGBLike color) {
        return this.backgroundColor(TextDisplayBuilder.rgbToInt(color));
    }

    public TextDisplayBuilder backgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public byte opacity() {
        return this.opacity;
    }

    public TextDisplayBuilder opacity(byte opacity) {
        this.opacity = opacity;
        return this;
    }

    public boolean hasShadow() {
        return this.hasShadow;
    }

    public TextDisplayBuilder hasShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
        return this;
    }

    public boolean isSeeThrough() {
        return this.isSeeThrough;
    }

    public TextDisplayBuilder isSeeThrough(boolean isSeeThrough) {
        this.isSeeThrough = isSeeThrough;
        return this;
    }

    public boolean hasDefaultBackground() {
        return this.hasDefaultBackground;
    }

    public TextDisplayBuilder hasDefaultBackground(boolean hasDefaultBackground) {
        this.hasDefaultBackground = hasDefaultBackground;
        return this;
    }

    public TextDisplay.Alignment alignment() {
        return this.alignment;
    }

    public TextDisplayBuilder alignment(TextDisplay.Alignment alignment) {
        this.alignment = Objects.requireNonNull(alignment);
        return this;
    }
}

