/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity;

import java.util.function.Predicate;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.potion.Potion;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.potion.PotionEffectTag;
import me.moros.bending.api.platform.world.WorldUtil;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static boolean isAgainstWall(Entity entity, Predicate<Block> predicate) {
        Block origin = entity.block();
        for (Direction face : WorldUtil.SIDES) {
            Block relative = origin.offset(face);
            if (!relative.type().isCollidable() || relative.type() == BlockType.BARRIER || !predicate.test(relative)) continue;
            return true;
        }
        return false;
    }

    public static void removeNegativeEffects(LivingEntity entity) {
        entity.activePotions().stream().map(Potion::effect).filter(PotionEffectTag.HARMFUL::isTagged).forEach(entity::removePotion);
    }

    public static boolean tryAddPotion(Entity entity, PotionEffect type, int duration, int amplifier) {
        if (amplifier >= 0 && duration > 0 && entity.valid() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int minDuration = PotionEffectTag.BENEFICIAL.isTagged(type) ? duration : 20;
            Potion potion = livingEntity.potion(type);
            if (potion == null || potion.duration() < minDuration || potion.amplifier() < amplifier) {
                int ticks = potion == null ? duration : EntityUtil.calculateDuration(type, amplifier, potion.duration(), duration);
                livingEntity.addPotion(type.builder().duration(ticks).amplifier(amplifier).build());
                return true;
            }
        }
        return false;
    }

    private static int calculateDuration(PotionEffect type, int amplifier, int duration, int maxDuration) {
        int k = 0;
        if (type == PotionEffect.REGENERATION) {
            k = 50 >> amplifier;
        } else if (type == PotionEffect.POISON) {
            k = 25 >> amplifier;
        } else if (type == PotionEffect.WITHER) {
            k = 40 >> amplifier;
        }
        int offset = k > 0 && duration + k <= maxDuration ? k : 0;
        return duration + offset;
    }

    public static boolean tryRemovePotion(Entity entity, PotionEffect type, int maxDuration, int maxAmplifier) {
        LivingEntity livingEntity;
        Potion potion;
        if (entity.valid() && entity instanceof LivingEntity && (potion = (livingEntity = (LivingEntity)entity).potion(type)) != null && potion.duration() <= maxDuration && potion.amplifier() <= maxAmplifier) {
            livingEntity.removePotion(type);
            return true;
        }
        return false;
    }
}

