/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.block;

import java.util.Optional;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKey;
import me.moros.math.Position;
import me.moros.math.adapter.Adapters;

public record Block(World world, int blockX, int blockY, int blockZ) implements Position,
DataHolder
{
    public Block(World world, Position position) {
        this(world, position.blockX(), position.blockY(), position.blockZ());
    }

    public Block offset(Position offset) {
        return this.offset(offset, 1);
    }

    public Block offset(Position offset, int m) {
        return this.offset(m * offset.blockX(), m * offset.blockY(), m * offset.blockZ());
    }

    public Block offset(int dx, int dy, int dz) {
        return new Block(this.world(), this.blockX + dx, this.blockY + dy, this.blockZ + dz);
    }

    public BlockType type() {
        return this.world().getBlockType(this);
    }

    public boolean setType(BlockType type) {
        return this.setState(type.defaultState());
    }

    public BlockState state() {
        return this.world().getBlockState(this);
    }

    public boolean setState(BlockState state) {
        return this.world().setBlockStateFast(this, state);
    }

    public AABB bounds() {
        return this.world().blockBounds(this);
    }

    @Override
    public double x() {
        return this.blockX;
    }

    @Override
    public double y() {
        return this.blockY;
    }

    @Override
    public double z() {
        return this.blockZ;
    }

    @Override
    public Adapters<? extends Position> adapters() {
        return Adapters.vector3i();
    }

    @Override
    public <T> Optional<T> get(DataKey<T> key) {
        return this.world().blockMetadata(this).get(key);
    }

    @Override
    public <T> void add(DataKey<T> key, T value) {
        this.world().blockMetadata(this).add(key, value);
    }

    @Override
    public <T> void remove(DataKey<T> key) {
        this.world().blockMetadata(this).remove(key);
    }
}

