/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.SphereImpl;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public sealed interface Sphere
extends Collider
permits SphereImpl {
    public double radius();

    @Override
    default public Collider.Type type() {
        return Collider.Type.SPHERE;
    }

    @Override
    default public AABB outer() {
        Vector3d half = this.halfExtents();
        return AABB.of((Vector3d)this.position().subtract(half), (Vector3d)this.position().add(half));
    }

    @Override
    default public Sphere at(Position point) {
        return Sphere.of(point.toVector3d(), this.radius());
    }

    @Override
    default public Vector3d halfExtents() {
        return Vector3d.of(this.radius(), this.radius(), this.radius());
    }

    @Override
    default public boolean contains(Vector3d point) {
        double distSq = this.position().distanceSq(point);
        return distSq <= this.radius() * this.radius();
    }

    public static Sphere of(double radius) {
        return Sphere.of(Vector3d.ZERO, radius);
    }

    public static Sphere of(Vector3d center, double radius) {
        return new SphereImpl(center, radius);
    }
}

