/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.HashSet;
import java.util.function.Predicate;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.VectorUtil;

public abstract class ParticleStream
implements Updatable,
SimpleAbility {
    private final User user;
    protected final Ray ray;
    protected Predicate<BlockType> canCollide = b -> false;
    private Ray collider;
    private Vector3d location;
    protected final Vector3d dir;
    protected boolean livingOnly = true;
    protected boolean selfCollision = false;
    protected boolean singleCollision = false;
    protected int steps = 1;
    protected double distanceTravelled = 0.0;
    protected double collisionRadius;
    private Vector3d expansion;
    protected final double speed;
    protected final double maxRange;

    protected ParticleStream(User user, Ray ray, double speed, double collisionRadius) {
        this.user = user;
        this.ray = ray;
        this.speed = speed;
        this.location = ray.position();
        this.maxRange = ray.direction().length();
        this.collisionRadius = collisionRadius;
        this.dir = (Vector3d)ray.direction().normalize().multiply(speed);
        this.collider = Ray.of(this.location, (Vector3d)this.dir.multiply(this.steps));
        this.expansion = this.calculateExpansion();
    }

    private Vector3d calculateExpansion() {
        return (Vector3d)Vector3d.ONE.multiply(this.collisionRadius);
    }

    @Override
    public Updatable.UpdateResult update() {
        Vector3d vector = this.controlDirection();
        Vector3d originalLocation = this.location;
        double originalCollisionRadius = this.collisionRadius;
        this.expansion = this.calculateExpansion();
        for (int i = 0; i < this.steps; ++i) {
            this.render(this.location);
            this.postRender(this.location);
            Vector3d originalVector = this.location;
            this.location = (Vector3d)this.location.add(vector);
            this.distanceTravelled += this.speed;
            if (this.location.distanceSq(this.ray.position()) > this.maxRange * this.maxRange || !this.user.canBuild(this.location)) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (this.validDiagonals(originalVector, this.dir)) continue;
            return Updatable.UpdateResult.REMOVE;
        }
        this.collider = Ray.of(originalLocation, (Vector3d)vector.multiply(this.steps));
        AABB outer = AABB.fromRay(this.collider, originalCollisionRadius);
        boolean hitEntity = CollisionUtil.handle(this.user, outer, this::onFilteredEntityHit, this.livingOnly, false, this.singleCollision);
        if (this.selfCollision) {
            hitEntity |= this.onFilteredEntityHit(this.user);
        }
        return hitEntity ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    protected boolean onFilteredEntityHit(Entity entity) {
        return this.collider.intersects(entity.bounds().grow(this.expansion)) && this.onEntityHit(entity);
    }

    private boolean validDiagonals(Vector3d originalVector, Vector3d directionVector) {
        Block originBlock = this.user.world().blockAt(originalVector);
        HashSet<Block> toCheck = new HashSet<Block>();
        if (this.speed > 1.0) {
            toCheck.add(this.user.world().blockAt((Position)originalVector.add((Position)directionVector.multiply(0.5))));
        }
        for (Vector3i v : VectorUtil.decomposeDiagonals(originalVector, directionVector)) {
            toCheck.add(originBlock.offset(v));
        }
        return toCheck.stream().noneMatch(this::testCollision);
    }

    private boolean testCollision(Block block) {
        if (this.canCollide.test(block.type()) && this.onBlockHit(block)) {
            return true;
        }
        if (!MaterialUtil.isTransparent(block) && block.bounds().grow(this.expansion).intersects(this.collider)) {
            return this.onBlockHit(block);
        }
        return false;
    }

    protected Vector3d controlDirection() {
        return this.dir;
    }

    @Override
    public Collider collider() {
        return this.collider;
    }
}

