/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.function.Predicate;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.VectorUtil;

public abstract class MovementResolver {
    private final World world;
    protected Predicate<Block> diagonalsPredicate = MaterialUtil::isTransparent;

    protected MovementResolver(World world) {
        this.world = world;
    }

    protected Resolved resolve(Vector3d origin, Vector3d direction) {
        Vector3d temp = (Vector3d)origin.add(direction);
        Block original = this.world.blockAt(origin);
        Block destination = this.world.blockAt(temp);
        int offset = 0;
        if (!this.isValidBlock(destination)) {
            if (this.isValidBlock(destination.offset(Direction.UP)) && this.diagonalsPredicate.test(original.offset(Direction.UP))) {
                offset = 1;
            } else if (this.isValidBlock(destination.offset(Direction.DOWN)) && this.diagonalsPredicate.test(destination)) {
                offset = -1;
            } else {
                this.onCollision(temp);
                return new Resolved(temp, false);
            }
        }
        int diagonalCollisions = 0;
        for (Vector3i v : VectorUtil.decomposeDiagonals(origin, direction)) {
            Block block = original.offset(v.blockX(), v.blockY() + offset, v.blockZ());
            if (this.isValidBlock(block) || ++diagonalCollisions <= 1) continue;
            Vector3d point = ((Vector3d)temp.add(v)).add(0.0, offset, 0.0);
            this.onCollision(point);
            return new Resolved(point, false);
        }
        return new Resolved(temp.add(0.0, offset, 0.0), true);
    }

    protected abstract boolean isValidBlock(Block var1);

    protected void onCollision(Vector3d point) {
    }

    protected record Resolved(Vector3d point, boolean success) {
    }
}

