/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.ArrayList;
import java.util.Iterator;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.MovementResolver;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.GridIterator;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public abstract class BlockLine
extends MovementResolver
implements Updatable {
    private final User user;
    private final Iterator<Vector2i> iterator;
    private final double maxRange;
    protected final Ray ray;
    protected Vector3d location;
    protected Vector3d dir;
    protected long interval = 0L;
    protected double distanceTravelled = 0.0;
    protected boolean diagonalMovement = true;
    private long nextUpdate = 0L;

    protected BlockLine(User user, Ray ray) {
        super(user.world());
        this.user = user;
        this.ray = ray;
        this.maxRange = ray.direction().length();
        this.dir = ((Vector3d)ray.direction().withY(0.0)).normalize();
        this.location = ray.position();
        ArrayList vectors = new ArrayList();
        GridIterator.create(this.location, this.dir, FastMath.ceil(this.maxRange)).forEachRemaining(b -> vectors.add(new Vector2i(b.blockX(), b.blockZ())));
        this.iterator = vectors.iterator();
    }

    @Override
    public Updatable.UpdateResult update() {
        double d;
        MovementResolver.Resolved resolved;
        if (this.interval >= 50L) {
            long time = System.currentTimeMillis();
            if (time < this.nextUpdate) {
                return Updatable.UpdateResult.CONTINUE;
            }
            this.nextUpdate = time + this.interval;
        }
        Vector3d temp = this.location;
        if (!this.diagonalMovement) {
            if (!this.iterator.hasNext()) {
                return Updatable.UpdateResult.REMOVE;
            }
            Vector2i v = this.iterator.next();
            temp = Vector3d.of((double)v.x() + 0.5, FastMath.floor(this.location.y() + 0.5), (double)v.z() + 0.5);
        }
        if (!(resolved = this.resolve(temp, this.dir)).success()) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.location = resolved.point();
        Block block = this.user.world().blockAt(this.location);
        if (this.location.distanceSq(this.ray.position()) > this.maxRange * this.maxRange) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.canBuild(block)) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.distanceTravelled += 1.0;
        if (d > 1.0) {
            this.render(block);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    public abstract void render(Block var1);

    protected record Vector2i(int x, int z) {
        public static Vector2i at(int x, int z) {
            return new Vector2i(x, z);
        }
    }
}

