/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Disk;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.user.User;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public abstract class AbstractWheel
implements Updatable,
SimpleAbility {
    private final User user;
    private final Vector3d dir;
    private final AABB box;
    protected final Disk collider;
    protected final Ray ray;
    private Vector3d location;
    protected final double radius;

    protected AbstractWheel(User user, Ray ray, double radius, double speed) {
        this.user = user;
        this.ray = ray;
        this.location = ray.position();
        this.radius = radius;
        this.dir = (Vector3d)ray.direction().normalize().multiply(speed);
        this.box = AABB.of(Vector3d.of(-radius, -radius, -radius), Vector3d.of(radius, radius, radius));
        AABB bounds = AABB.of(Vector3d.of(-0.15, -radius, -radius), Vector3d.of(0.15, radius, radius));
        double angle = Math.toRadians(user.yaw());
        OBB obb = OBB.of(bounds, Vector3d.PLUS_J, angle);
        this.collider = Disk.of(Sphere.of(radius), obb).at(this.location);
    }

    @Override
    public Updatable.UpdateResult update() {
        this.location = (Vector3d)this.location.add(this.dir);
        if (!this.user.canBuild(this.location)) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.resolveMovement()) {
            return Updatable.UpdateResult.REMOVE;
        }
        Block base = this.user.world().blockAt((Position)this.location.subtract(0.0, this.radius + 0.25, 0.0));
        if (base.type().isLiquid()) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.render(this.location);
        this.postRender(this.location);
        this.onBlockHit(base.offset(Direction.UP));
        boolean hit = CollisionUtil.handle(this.user, this.collider(), this);
        return hit ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public boolean onBlockHit(Block block) {
        return true;
    }

    @Override
    public Collider collider() {
        return this.collider.at(this.location);
    }

    public Vector3d location() {
        return this.location;
    }

    public boolean resolveMovement() {
        double r = this.radius + 0.05;
        List nearbyBlocks = this.user.world().nearbyBlocks(this.box.at(this.location));
        Collider checkCollider = this.collider();
        double topY = this.location.y() + r;
        double bottomY = this.location.y() - r;
        for (Block block : nearbyBlocks) {
            AABB blockBounds = block.bounds();
            if (!blockBounds.intersects(checkCollider)) continue;
            if (blockBounds.min().y() > topY) {
                return false;
            }
            double resolution = blockBounds.max().y() - bottomY;
            if (Math.abs(resolution) > this.radius + 0.1) {
                return false;
            }
            this.location = this.location.add(0.0, resolution, 0.0);
            return this.checkCollisions(nearbyBlocks);
        }
        Vector3d offset = Vector3d.of(0.0, this.radius - 0.125, 0.0);
        Vector3d bottom = (Vector3d)this.location.subtract(offset);
        if (!this.user.world().blockAt(bottom).type().isCollidable()) {
            Vector3d pos = (Vector3d)Context.builder(bottom, Vector3d.MINUS_J).range(0.75 * this.radius).blocks(this.user.world()).position().add(offset);
            Disk tempCollider = this.collider.at(pos);
            if (nearbyBlocks.stream().map(Block::bounds).noneMatch(tempCollider::intersects)) {
                this.location = pos;
                return true;
            }
        }
        return this.checkCollisions(nearbyBlocks);
    }

    private boolean checkCollisions(Collection<Block> nearbyBlocks) {
        Collider checkCollider = this.collider();
        return nearbyBlocks.stream().map(Block::bounds).noneMatch(checkCollider::intersects);
    }
}

