/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.MovementResolver;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.collision.raytrace.CompositeRayTrace;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.user.User;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;

public abstract class AbstractLine
extends MovementResolver
implements Updatable,
SimpleAbility {
    private final User user;
    protected final Vector3d origin;
    private Vector3d location;
    protected Vector3d targetLocation;
    protected Vector3d direction;
    protected Collider collider;
    protected Entity target;
    protected final double range;
    protected final double speed;
    protected boolean locked;
    protected boolean controllable = false;
    protected boolean skipVertical = false;

    protected AbstractLine(User user, Block source, double range, double speed, boolean followTarget) {
        super(user.world());
        this.user = user;
        this.origin = this.location = source.toVector3d().add(0.5, 1.25, 0.5);
        this.range = range;
        this.speed = speed;
        CompositeRayTrace result = user.rayTrace(range).cast(user.world());
        this.target = result.entity();
        this.targetLocation = result.entityCenterOrPosition();
        this.locked = followTarget && this.target != null;
        this.direction = ((Vector3d)((Vector3d)this.targetLocation.subtract(this.location)).withY(0.0)).normalize();
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.locked) {
            if (this.isValidTarget()) {
                this.targetLocation = this.target.location();
                this.direction = ((Vector3d)((Vector3d)this.targetLocation.subtract(this.location)).withY(0.0)).normalize();
            } else {
                this.locked = false;
            }
        }
        if (this.controllable) {
            this.targetLocation = this.user.rayTrace(this.range).cast(this.user.world()).entityCenterOrPosition();
            this.direction = ((Vector3d)((Vector3d)this.targetLocation.subtract(this.origin)).withY(0.0)).normalize();
        }
        if (this.onBlockHit(this.user.world().blockAt(this.location).offset(Direction.DOWN))) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.collider = Sphere.of(this.location, 1.0);
        if (CollisionUtil.handle(this.user, this.collider, this, true)) {
            return Updatable.UpdateResult.REMOVE;
        }
        MovementResolver.Resolved resolved = this.resolve(this.location, this.direction);
        if (!resolved.success()) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.render(this.location);
        this.render((Vector3d)((Vector3d)this.location.add(resolved.point())).multiply(0.5));
        this.location = resolved.point();
        this.postRender(this.location);
        Block block = this.user.world().blockAt(this.location);
        if (this.skipVertical) {
            int y2;
            int y1 = FastMath.floor(this.targetLocation.y());
            if (y1 > (y2 = FastMath.floor(resolved.point().y())) && this.isValidBlock(block.offset(Direction.UP))) {
                this.location = (Vector3d)resolved.point().add(Vector3d.PLUS_J);
                block = block.offset(Direction.UP);
            } else if (y1 < y2 && this.isValidBlock(block.offset(Direction.DOWN))) {
                this.location = (Vector3d)resolved.point().add(Vector3d.MINUS_J);
                block = block.offset(Direction.DOWN);
            }
        }
        if (this.location.distanceSq(this.origin) > this.range * this.range) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.canBuild(block)) {
            return Updatable.UpdateResult.REMOVE;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public Collider collider() {
        return this.collider;
    }

    protected boolean isValidTarget() {
        if (this.target == null || !this.target.valid()) {
            return false;
        }
        return this.target.worldKey().equals((Object)this.user.worldKey()) && this.targetLocation.distanceSq(this.target.location()) < 25.0;
    }
}

