/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;

public class EarthSpike
implements Updatable {
    private static final long DELAY = 80L;
    private static final long DURATION = 15000L;
    private final Block origin;
    private final int length;
    private int currentLength = 0;
    private long nextUpdateTime;

    public EarthSpike(Block origin, int length, boolean delay) {
        this.origin = origin;
        this.length = length;
        this.nextUpdateTime = delay ? System.currentTimeMillis() + 80L : 0L;
    }

    @Override
    public Updatable.UpdateResult update() {
        Block currentIndex;
        if (this.currentLength >= this.length) {
            return Updatable.UpdateResult.REMOVE;
        }
        long time = System.currentTimeMillis();
        if (time < this.nextUpdateTime) {
            return Updatable.UpdateResult.CONTINUE;
        }
        if (this.currentLength == 0) {
            if (!EarthMaterials.isEarthOrSand(this.origin)) {
                return Updatable.UpdateResult.REMOVE;
            }
            TempBlock.builder(MaterialUtil.solidType(this.origin.type(), BlockType.DRIPSTONE_BLOCK)).duration(15000L).build(this.origin);
        }
        this.nextUpdateTime = time + 80L;
        if (!this.canMove(currentIndex = this.origin.offset(Direction.UP, ++this.currentLength))) {
            return Updatable.UpdateResult.REMOVE;
        }
        Vector3d center = currentIndex.center();
        BlockType.DRIPSTONE_BLOCK.asParticle(center).count(24).offset(0.2).spawn(currentIndex.world());
        TempBlock.builder(BlockType.POINTED_DRIPSTONE).duration(15000L - (long)this.currentLength * 80L).build(currentIndex);
        SoundEffect.EARTH.play(currentIndex);
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean canMove(Block newBlock) {
        if (MaterialUtil.isLava(newBlock)) {
            return false;
        }
        if (!MaterialUtil.isTransparent(newBlock)) {
            return false;
        }
        WorldUtil.tryBreakPlant(newBlock);
        return true;
    }
}

