/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.storage;

import java.util.Locale;

public enum StorageType {
    MYSQL("MySQL", "com.mysql.cj.jdbc.Driver", "com.mysql.cj.jdbc.MysqlDataSource", false),
    MARIADB("MariaDB", "org.mariadb.jdbc.Driver", "org.mariadb.jdbc.MariaDbDataSource", false),
    POSTGRESQL("PostgreSQL", "org.postgresql.ds.PGSimpleDataSource", "org.postgresql.Driver", false),
    SQLITE("SQLite", "org.sqlite.JDBC", "org.sqlite.SQLiteDataSource", true),
    H2("H2", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", true),
    HSQL("HSQLDB", "org.hsqldb.jdbc.JDBCDriver", "org.hsqldb.jdbc.JDBCDataSource", true);

    private final String name;
    private final String driver;
    private final String dataSource;
    private final boolean local;

    private StorageType(String name, String driver, String dataSource, boolean local) {
        this.name = name;
        this.driver = driver;
        this.dataSource = dataSource;
        this.local = local;
    }

    public String toString() {
        return this.name;
    }

    public String realName() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public String driver() {
        return this.driver;
    }

    public String dataSource() {
        return this.dataSource;
    }

    public boolean isLocal() {
        return this.local;
    }
}

