/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class SqlStreamReader {
    private SqlStreamReader() {
    }

    public static List<String> parseQueries(InputStream is) {
        ArrayList<String> queries = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--")) continue;
                sb.append(line);
                if (!line.endsWith(";")) continue;
                sb.deleteCharAt(sb.length() - 1);
                String result = sb.toString().trim();
                if (!result.isEmpty()) {
                    queries.add(result);
                }
                sb = new StringBuilder();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return queries;
    }
}

