/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.storage;

import bending.libraries.storage.StorageDataSource;
import bending.libraries.storage.StorageType;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Builder {
    private final StorageType engine;
    private final HikariConfig config;
    private final Properties dataSourceProperties;
    private Path path = null;
    private String host = "localhost";
    private String database = "";
    private int port;
    private boolean optimize;
    private boolean memory;

    Builder(StorageType engine) {
        this.engine = engine;
        this.config = new HikariConfig();
        this.dataSourceProperties = new Properties();
        this.optimize = engine == StorageType.MYSQL;
    }

    public Builder path(Path path) {
        this.path = Objects.requireNonNull(path);
        return this;
    }

    public Builder host(String host) {
        this.host = Objects.requireNonNull(host);
        this.dataSourceProperties.put("serverName", this.host);
        return this;
    }

    public Builder database(String database) {
        this.database = Objects.requireNonNull(database);
        this.dataSourceProperties.put("databaseName", this.database);
        return this;
    }

    public Builder username(@Nullable String username) {
        this.config.setUsername(username);
        return this;
    }

    public Builder password(@Nullable String password) {
        this.config.setPassword(password);
        return this;
    }

    public Builder port(int port) {
        this.port = port;
        this.dataSourceProperties.put("portNumber", this.host);
        return this;
    }

    public Builder configure(Consumer<HikariConfig> consumer) {
        consumer.accept(this.config);
        return this;
    }

    public Builder properties(Consumer<Properties> consumer) {
        consumer.accept(this.dataSourceProperties);
        return this;
    }

    public Builder noOptimization() {
        this.optimize = false;
        return this;
    }

    public Builder memory(boolean memory) {
        this.memory = memory;
        return this;
    }

    public @Nullable StorageDataSource build(String poolName) {
        SimpleStorage simpleStorage;
        block10: {
            if (this.engine.isLocal() && this.path == null) {
                throw new IllegalStateException("Connection path is missing!");
            }
            this.config.setPoolName(poolName);
            if (this.optimize) {
                this.addOptimizedProperties();
            }
            this.config.setDataSourceProperties(this.dataSourceProperties);
            String url = this.engine.isLocal() ? this.path.toString() : "//" + this.host + ":" + this.port + "/" + this.database;
            this.setDriverClassAndUrl(this.engine.driver(), this.formatUrl(url));
            HikariDataSource ds = new HikariDataSource(this.config);
            Connection ignored = ds.getConnection();
            try {
                simpleStorage = new SimpleStorage(this.engine, ds);
                if (ignored == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            ignored.close();
        }
        return simpleStorage;
    }

    private String formatUrl(String extra) {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:").append(this.engine.realName()).append(":");
        if (this.engine.isLocal()) {
            if (this.memory) {
                sb.append(this.engine == StorageType.SQLITE ? ":memory:" : "mem:");
            } else if (this.engine == StorageType.HSQL) {
                sb.append("file:");
            }
        }
        return sb.append(extra).toString();
    }

    private void setDriverClassAndUrl(String driverClassName, String jdbcUrl) {
        if (this.nullOrEmpty(this.config.getDriverClassName())) {
            this.config.setDriverClassName(driverClassName);
        }
        if (this.nullOrEmpty(this.config.getJdbcUrl())) {
            this.config.setJdbcUrl(jdbcUrl);
        }
    }

    private boolean nullOrEmpty(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    private void addOptimizedProperties() {
        this.dataSourceProperties.put("cachePrepStmts", (Object)true);
        this.dataSourceProperties.put("prepStmtCacheSize", (Object)250);
        this.dataSourceProperties.put("prepStmtCacheSqlLimit", (Object)2048);
        this.dataSourceProperties.put("useServerPrepStmts", (Object)true);
        this.dataSourceProperties.put("useLocalSessionState", (Object)true);
        this.dataSourceProperties.put("rewriteBatchedStatements", (Object)true);
        this.dataSourceProperties.put("cacheResultSetMetadata", (Object)true);
        this.dataSourceProperties.put("cacheServerConfiguration", (Object)true);
        this.dataSourceProperties.put("elideSetAutoCommits", (Object)true);
        this.dataSourceProperties.put("maintainTimeStats", (Object)false);
    }

    private record SimpleStorage(StorageType type, HikariDataSource source) implements StorageDataSource
    {
    }
}

