/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.inventoryframework.pane;

import bending.libraries.inventoryframework.gui.GuiItem;
import bending.libraries.inventoryframework.gui.InventoryComponent;
import bending.libraries.inventoryframework.gui.type.util.Gui;
import bending.libraries.inventoryframework.pane.Pane;
import bending.libraries.inventoryframework.pane.util.Mask;
import bending.libraries.inventoryframework.pane.util.Slot;
import bending.libraries.inventoryframework.util.GeometryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OutlinePane
extends Pane {
    @NotNull
    private final List<GuiItem> items;
    private int rotation;
    private int gap;
    private boolean repeat;
    @NotNull
    private Alignment alignment = Alignment.BEGIN;
    @NotNull
    private Mask mask;

    public OutlinePane(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
        this.items = new ArrayList<GuiItem>(length * height);
        Object[] mask = new String[height];
        StringBuilder maskString = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            maskString.append('1');
        }
        Arrays.fill(mask, maskString.toString());
        this.mask = new Mask((String[])mask);
    }

    public OutlinePane(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        this(Slot.fromXY(x, y), length, height, priority);
    }

    public OutlinePane(@NotNull Slot slot, int length, int height) {
        this(slot, length, height, Pane.Priority.NORMAL);
    }

    public OutlinePane(int x, int y, int length, int height) {
        this(x, y, length, height, Pane.Priority.NORMAL);
    }

    public OutlinePane(int length, int height) {
        this(0, 0, length, height);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int itemIndex = 0;
        int gapCount = 0;
        for (int vectorIndex = 0; vectorIndex < height && this.getItems().size() > itemIndex; ++vectorIndex) {
            int index;
            GuiItem[] items;
            boolean[] maskLine = this.mask.getRow(vectorIndex);
            int enabled = 0;
            for (boolean bool : maskLine) {
                if (!bool) continue;
                ++enabled;
            }
            if (this.doesRepeat()) {
                items = new GuiItem[enabled];
            } else {
                int remainingPositions = gapCount + (this.getItems().size() - itemIndex - 1) * (this.getGap() + 1) + 1;
                items = new GuiItem[Math.min(enabled, remainingPositions)];
            }
            for (index = 0; index < items.length; ++index) {
                if (gapCount == 0) {
                    items[index] = (GuiItem)this.getItems().get(itemIndex);
                    if (this.doesRepeat() && ++itemIndex >= this.getItems().size()) {
                        itemIndex = 0;
                    }
                    gapCount = this.getGap();
                    continue;
                }
                items[index] = null;
                --gapCount;
            }
            if (this.getAlignment() == Alignment.BEGIN) {
                index = 0;
            } else if (this.getAlignment() == Alignment.CENTER) {
                index = -((enabled - items.length) / 2);
            } else {
                throw new IllegalStateException("Unknown alignment '" + String.valueOf((Object)this.getAlignment()) + "'");
            }
            for (int opposingVectorIndex = 0; opposingVectorIndex < maskLine.length; ++opposingVectorIndex) {
                if (!maskLine[opposingVectorIndex]) continue;
                if (index >= 0 && index < items.length && items[index] != null) {
                    int x = opposingVectorIndex;
                    int y = vectorIndex;
                    Map.Entry<Integer, Integer> coordinates = GeometryUtil.processClockwiseRotation(x, y, length, height, this.rotation);
                    x = coordinates.getKey();
                    y = coordinates.getValue();
                    if (x >= 0 && x < length && y >= 0 && y < height) {
                        Slot slot = this.getSlot();
                        int finalRow = slot.getY(maxLength) + y + paneOffsetY;
                        int finalColumn = slot.getX(maxLength) + x + paneOffsetX;
                        GuiItem item = items[index];
                        if (item.isVisible()) {
                            inventoryComponent.setItem(item, finalColumn, finalRow);
                        }
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return false;
        }
        GuiItem item = OutlinePane.findMatchingItem(this.items, itemStack);
        if (item == null) {
            return false;
        }
        item.callAction(event);
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public OutlinePane copy() {
        OutlinePane outlinePane = new OutlinePane(this.getSlot(), this.length, this.height, this.getPriority());
        for (GuiItem item : this.items) {
            outlinePane.addItem(item.copy());
        }
        outlinePane.setVisible(this.isVisible());
        outlinePane.onClick = this.onClick;
        outlinePane.uuid = this.uuid;
        outlinePane.rotation = this.rotation;
        outlinePane.gap = this.gap;
        outlinePane.repeat = this.repeat;
        outlinePane.mask = this.mask;
        outlinePane.alignment = this.alignment;
        return outlinePane;
    }

    public void insertItem(@NotNull GuiItem item, int index) {
        this.items.add(index, item);
    }

    public void addItem(@NotNull GuiItem item) {
        this.items.add(item);
    }

    public void removeItem(@NotNull GuiItem item) {
        this.items.remove(item);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    public void applyMask(@NotNull Mask mask) {
        if (this.length != mask.getLength() || this.height != mask.getHeight()) {
            throw new IllegalArgumentException("Mask's dimension must be the same as the pane's dimension");
        }
        this.mask = mask;
    }

    @Override
    public void setLength(int length) {
        super.setLength(length);
        this.applyMask(this.getMask().setLength(length));
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.applyMask(this.getMask().setHeight(height));
    }

    public void align(@NotNull Alignment alignment) {
        this.alignment = alignment;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes() {
        return new HashSet<Pane>();
    }

    @NotNull
    @Contract(pure=true)
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Contract(pure=true)
    public boolean doesRepeat() {
        return this.repeat;
    }

    @Contract(pure=true)
    public int getGap() {
        return this.gap;
    }

    @NotNull
    public List<GuiItem> getItems() {
        return this.items;
    }

    @NotNull
    @Contract(pure=true)
    public Mask getMask() {
        return this.mask;
    }

    public static enum Alignment {
        BEGIN,
        CENTER;

    }
}

