/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.inventoryframework.gui.type;

import bending.libraries.inventoryframework.HumanEntityCache;
import bending.libraries.inventoryframework.gui.GuiItem;
import bending.libraries.inventoryframework.gui.InventoryComponent;
import bending.libraries.inventoryframework.gui.type.util.InventoryBased;
import bending.libraries.inventoryframework.gui.type.util.MergedGui;
import bending.libraries.inventoryframework.gui.type.util.NamedGui;
import bending.libraries.inventoryframework.pane.Pane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ChestGui
extends NamedGui
implements MergedGui,
InventoryBased {
    @NotNull
    private InventoryComponent inventoryComponent;
    private boolean dirtyRows = false;

    public ChestGui(int rows, @NotNull Component title) {
        this(rows, title, (Plugin)JavaPlugin.getProvidingPlugin(ChestGui.class));
    }

    public ChestGui(int rows, @NotNull Component title, @NotNull Plugin plugin) {
        super(title, plugin);
        if (rows < 1 || rows > 6) {
            throw new IllegalArgumentException("Rows should be between 1 and 6");
        }
        this.inventoryComponent = new InventoryComponent(9, rows + 4);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.isDirty() || this.dirtyRows) {
            this.inventory = this.createInventory();
            this.dirtyRows = false;
            this.markChanges();
        }
        this.getInventory().clear();
        int height = this.getInventoryComponent().getHeight();
        this.getInventoryComponent().display();
        InventoryComponent topComponent = this.getInventoryComponent().excludeRows(height - 4, height - 1);
        InventoryComponent bottomComponent = this.getInventoryComponent().excludeRows(0, height - 5);
        topComponent.placeItems(this.getInventory(), 0);
        if (bottomComponent.hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            bottomComponent.placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public ChestGui copy() {
        ChestGui gui = new ChestGui(this.getRows(), this.getTitle(), this.plugin);
        gui.inventoryComponent = this.inventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        this.getInventoryComponent().click(this, event, event.getRawSlot());
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getInventoryComponent().excludeRows(0, this.getInventoryComponent().getHeight() - 5).hasItem();
    }

    public void setRows(int rows) {
        if (rows < 1 || rows > 6) {
            throw new IllegalArgumentException("Rows should be between 1 and 6");
        }
        InventoryComponent inventoryComponent = new InventoryComponent(9, rows + 4);
        for (Pane pane : this.inventoryComponent.getPanes()) {
            inventoryComponent.addPane(pane);
        }
        this.inventoryComponent = inventoryComponent;
        this.dirtyRows = true;
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    public void addPane(@NotNull Pane pane) {
        this.inventoryComponent.addPane(pane);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<Pane> getPanes() {
        return this.inventoryComponent.getPanes();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        return Bukkit.createInventory((InventoryHolder)this, (int)(this.getRows() * 9), (Component)this.getTitle());
    }

    @Contract(pure=true)
    public int getRows() {
        return this.getInventoryComponent().getHeight() - 4;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public InventoryComponent getInventoryComponent() {
        return this.inventoryComponent;
    }
}

