/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.cloud.minecraft.extras;

import bending.libraries.cloud.description.Description;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RichDescription
implements Description {
    private static final RichDescription EMPTY = new RichDescription((Component)Component.empty());
    private final Component contents;

    RichDescription(@NonNull Component contents) {
        this.contents = contents;
    }

    public static @NonNull RichDescription empty() {
        return EMPTY;
    }

    public static @NonNull RichDescription of(@NonNull ComponentLike contents) {
        Component componentContents = Objects.requireNonNull(contents, "contents").asComponent();
        if (Component.empty().equals((Object)componentContents)) {
            return EMPTY;
        }
        return new RichDescription(componentContents);
    }

    public static @NonNull RichDescription richDescription(@NonNull ComponentLike contents) {
        return RichDescription.of(contents);
    }

    public static @NonNull RichDescription translatable(@NonNull String key) {
        Objects.requireNonNull(key, "key");
        return new RichDescription((Component)Component.translatable((String)key));
    }

    public static @NonNull RichDescription translatable(@NonNull String key, ComponentLike ... args) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(args, "args");
        return new RichDescription((Component)Component.translatable((String)key, (ComponentLike[])args));
    }

    @Override
    @Deprecated
    public @NonNull String textDescription() {
        return PlainComponentSerializer.plain().serialize(GlobalTranslator.render((Component)this.contents, (Locale)Locale.getDefault()));
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public @NonNull Component contents() {
        return this.contents;
    }

    @Override
    public boolean isEmpty() {
        return Component.empty().equals((Object)this.contents);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RichDescription that = (RichDescription)object;
        return Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(this.contents);
    }
}

