/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class TearUtils {
    private static int customModelData = 0;

    public static void setCustomModelData(int data) {
        customModelData = data;
    }

    public static ItemStack createCelestialTear() {
        ItemStack item = new ItemStack(Material.GHAST_TEAR, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Celestial Tear");
        meta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "Forged by storm winds", String.valueOf(ChatColor.GRAY) + "A source of celestial mobility"));
        if (customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createCelestialTear(int amount) {
        ItemStack item = TearUtils.createCelestialTear();
        item.setAmount(amount);
        return item;
    }

    public static boolean isCelestialTear(ItemStack item) {
        if (item == null || item.getType() != Material.GHAST_TEAR) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return false;
        }
        String stripped = ChatColor.stripColor((String)meta.getDisplayName());
        if (!"Celestial Tear".equalsIgnoreCase(stripped)) {
            return false;
        }
        if (customModelData > 0) {
            if (!meta.hasCustomModelData()) {
                return false;
            }
            return meta.getCustomModelData() == customModelData;
        }
        return true;
    }

    public static int countTears(Player player) {
        int count = 0;
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!TearUtils.isCelestialTear(item)) continue;
            count += item.getAmount();
        }
        return count;
    }

    public static int findTearSlot(Player player) {
        PlayerInventory inv = player.getInventory();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (!TearUtils.isCelestialTear(item)) continue;
            return i;
        }
        return -1;
    }

    public static void consumeTear(Player player, int slot) {
        PlayerInventory inv = player.getInventory();
        if (slot < 0 || slot >= inv.getSize()) {
            return;
        }
        ItemStack item = inv.getItem(slot);
        if (!TearUtils.isCelestialTear(item)) {
            return;
        }
        int newAmount = item.getAmount() - 1;
        if (newAmount <= 0) {
            inv.setItem(slot, null);
        } else {
            item.setAmount(newAmount);
            inv.setItem(slot, item);
        }
    }
}

