/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import com.minico.celestialdash.CelestialDash;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Messages {
    private final CelestialDash plugin;
    private String cooldownTemplate;
    private String noTearsMessage;
    private String dashUsedMessage;
    private String secondDashMessage;
    private String tearDropMessage;

    public Messages(CelestialDash plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.cooldownTemplate = this.color(this.plugin.getConfig().getString("messages.cooldown", "&7Celestial Dash ready in &b%seconds%s&7."));
        this.noTearsMessage = this.color(this.plugin.getConfig().getString("messages.no-tears", "&cYou need at least one &bCelestial Tear &cto use Celestial Dash."));
        this.dashUsedMessage = this.color(this.plugin.getConfig().getString("messages.dash-used", "&bThe celestial wind pushes you forward!"));
        this.secondDashMessage = this.color(this.plugin.getConfig().getString("messages.second-dash", "&bYou unleash a second celestial dash!"));
        this.tearDropMessage = this.color(this.plugin.getConfig().getString("messages.tear-drop", "&bA celestial tear materializes from the storm..."));
    }

    public String formatCooldown(long seconds) {
        return this.cooldownTemplate.replace("%seconds%", String.valueOf(seconds));
    }

    public String getNoTearsMessage() {
        return this.noTearsMessage;
    }

    public String getDashUsedMessage() {
        return this.dashUsedMessage;
    }

    public String getSecondDashMessage() {
        return this.secondDashMessage;
    }

    public void sendTearDropMessage(Player player) {
        if (this.tearDropMessage == null || this.tearDropMessage.isEmpty()) {
            return;
        }
        player.sendMessage(this.tearDropMessage);
    }

    private String color(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }
}

