/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import com.minico.celestialdash.CelestialDash;
import com.minico.celestialdash.TearUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DropHandler {
    private final CelestialDash plugin;
    private BukkitRunnable task;
    private final Map<UUID, Long> lastDrop = new HashMap<UUID, Long>();

    public DropHandler(CelestialDash plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    long last;
                    World world = player.getWorld();
                    if (DropHandler.this.plugin.isWorldBlacklistedForDrops(world.getName()) || !world.hasStorm()) continue;
                    UUID uuid = player.getUniqueId();
                    long now = System.currentTimeMillis();
                    if (now - (last = DropHandler.this.lastDrop.getOrDefault(uuid, 0L).longValue()) < DropHandler.this.plugin.getDropCooldownMs() || !(Math.random() < DropHandler.this.plugin.getDropChance())) continue;
                    ItemStack tear = TearUtils.createCelestialTear();
                    world.dropItemNaturally(player.getLocation(), tear);
                    DropHandler.this.lastDrop.put(uuid, now);
                    DropHandler.this.plugin.getMessages().sendTearDropMessage(player);
                }
            }
        };
        this.task.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.lastDrop.clear();
    }
}

