/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import com.minico.celestialdash.CelestialCommand;
import com.minico.celestialdash.CelestialPlaceholders;
import com.minico.celestialdash.DashHandler;
import com.minico.celestialdash.DropHandler;
import com.minico.celestialdash.Messages;
import com.minico.celestialdash.TearUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CelestialDash
extends JavaPlugin {
    private double dropChance = 0.03;
    private long dropCooldownMs = 60000L;
    private long dashCooldownMs = 10000L;
    private double dashStrength = 1.8;
    private double dashLift = 0.4;
    private int regenDurationTicks = 100;
    private int regenAmplifier = 0;
    private boolean dashParticleEnabled = true;
    private Particle dashParticle = Particle.CLOUD;
    private int dashParticleCount = 40;
    private double dashParticleOffsetX = 0.4;
    private double dashParticleOffsetY = 0.5;
    private double dashParticleOffsetZ = 0.4;
    private double dashParticleSpeed = 0.02;
    private boolean dashSoundEnabled = true;
    private Sound dashSound = Sound.ENTITY_PHANTOM_FLAP;
    private float dashSoundVolume = 1.2f;
    private float dashSoundPitch = 0.6f;
    private boolean trailEnabled = true;
    private Particle trailParticle = Particle.CLOUD;
    private int trailParticleCount = 20;
    private double trailOffsetX = 0.3;
    private double trailOffsetY = 0.4;
    private double trailOffsetZ = 0.3;
    private double trailSpeed = 0.01;
    private int trailDurationTicks = 10;
    private int trailIntervalTicks = 1;
    private boolean doubleDashEnabled = true;
    private long doubleDashWindowMs = 4000L;
    private int doubleDashFallImmunityTicks = 40;
    private int tearCustomModelData = 0;
    private final Set<String> dropBlacklistWorlds = new HashSet<String>();
    private Messages messages;
    private DashHandler dashHandler;
    private DropHandler dropHandler;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadSettings();
        TearUtils.setCustomModelData(this.tearCustomModelData);
        this.messages = new Messages(this);
        this.messages.reload();
        this.dashHandler = new DashHandler(this, this.messages);
        this.dropHandler = new DropHandler(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.dashHandler, (Plugin)this);
        PluginCommand cmd = this.getCommand("celestialdash");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)new CelestialCommand(this, this.messages));
        } else {
            this.getLogger().severe("Command 'celestialdash' is not defined in plugin.yml!");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new CelestialPlaceholders(this).register();
            this.getLogger().info("PlaceholderAPI hook enabled.");
        }
        this.dropHandler.start();
        this.getLogger().info("CelestialDash enabled.");
    }

    public void onDisable() {
        if (this.dropHandler != null) {
            this.dropHandler.stop();
        }
        this.getLogger().info("CelestialDash disabled.");
    }

    public void loadSettings() {
        this.dropChance = this.getConfig().getDouble("drop-chance-per-second", this.dropChance);
        this.dropCooldownMs = this.getConfig().getLong("drop-cooldown-seconds", this.dropCooldownMs / 1000L) * 1000L;
        this.dashCooldownMs = this.getConfig().getLong("dash-cooldown-seconds", this.dashCooldownMs / 1000L) * 1000L;
        this.dashStrength = this.getConfig().getDouble("dash-strength", this.dashStrength);
        this.dashLift = this.getConfig().getDouble("dash-vertical-lift", this.dashLift);
        this.regenDurationTicks = this.getConfig().getInt("regen-duration-seconds", this.regenDurationTicks / 20) * 20;
        this.regenAmplifier = this.getConfig().getInt("regen-amplifier", this.regenAmplifier);
        this.dashParticleEnabled = this.getConfig().getBoolean("dash-particle-enabled", this.dashParticleEnabled);
        String dashParticleName = this.getConfig().getString("dash-particle-type", this.dashParticle.name());
        try {
            this.dashParticle = Particle.valueOf((String)dashParticleName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid dash-particle-type: " + dashParticleName + ", using CLOUD");
            this.dashParticle = Particle.CLOUD;
        }
        this.dashParticleCount = this.getConfig().getInt("dash-particle-count", this.dashParticleCount);
        this.dashParticleOffsetX = this.getConfig().getDouble("dash-particle-offset-x", this.dashParticleOffsetX);
        this.dashParticleOffsetY = this.getConfig().getDouble("dash-particle-offset-y", this.dashParticleOffsetY);
        this.dashParticleOffsetZ = this.getConfig().getDouble("dash-particle-offset-z", this.dashParticleOffsetZ);
        this.dashParticleSpeed = this.getConfig().getDouble("dash-particle-speed", this.dashParticleSpeed);
        this.dashSoundEnabled = this.getConfig().getBoolean("dash-sound-enabled", this.dashSoundEnabled);
        String soundName = this.getConfig().getString("dash-sound-name", this.dashSound.name());
        try {
            this.dashSound = Sound.valueOf((String)soundName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid dash-sound-name: " + soundName + ", using ENTITY_PHANTOM_FLAP");
            this.dashSound = Sound.ENTITY_PHANTOM_FLAP;
        }
        this.dashSoundVolume = (float)this.getConfig().getDouble("dash-sound-volume", (double)this.dashSoundVolume);
        this.dashSoundPitch = (float)this.getConfig().getDouble("dash-sound-pitch", (double)this.dashSoundPitch);
        this.trailEnabled = this.getConfig().getBoolean("trail-enabled", this.trailEnabled);
        String trailName = this.getConfig().getString("trail-particle-type", this.trailParticle.name());
        try {
            this.trailParticle = Particle.valueOf((String)trailName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid trail-particle-type: " + trailName + ", using CLOUD");
            this.trailParticle = Particle.CLOUD;
        }
        this.trailParticleCount = this.getConfig().getInt("trail-particle-count", this.trailParticleCount);
        this.trailOffsetX = this.getConfig().getDouble("trail-offset-x", this.trailOffsetX);
        this.trailOffsetY = this.getConfig().getDouble("trail-offset-y", this.trailOffsetY);
        this.trailOffsetZ = this.getConfig().getDouble("trail-offset-z", this.trailOffsetZ);
        this.trailSpeed = this.getConfig().getDouble("trail-speed", this.trailSpeed);
        this.trailDurationTicks = this.getConfig().getInt("trail-duration-ticks", this.trailDurationTicks);
        this.trailIntervalTicks = this.getConfig().getInt("trail-interval-ticks", this.trailIntervalTicks);
        this.doubleDashEnabled = this.getConfig().getBoolean("double-dash.enabled", this.doubleDashEnabled);
        this.doubleDashWindowMs = this.getConfig().getLong("double-dash.window-ms", this.doubleDashWindowMs);
        this.doubleDashFallImmunityTicks = this.getConfig().getInt("double-dash.fall-immunity-ticks", this.doubleDashFallImmunityTicks);
        this.tearCustomModelData = this.getConfig().getInt("tear-custom-model-data", this.tearCustomModelData);
        List blacklist = this.getConfig().getStringList("drop-blacklist-worlds");
        this.dropBlacklistWorlds.clear();
        for (String name : blacklist) {
            if (name == null || name.isEmpty()) continue;
            this.dropBlacklistWorlds.add(name.toLowerCase());
        }
    }

    public Messages getMessages() {
        return this.messages;
    }

    public DashHandler getDashHandler() {
        return this.dashHandler;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public long getDropCooldownMs() {
        return this.dropCooldownMs;
    }

    public long getDashCooldownMs() {
        return this.dashCooldownMs;
    }

    public double getDashStrength() {
        return this.dashStrength;
    }

    public double getDashLift() {
        return this.dashLift;
    }

    public int getRegenDurationTicks() {
        return this.regenDurationTicks;
    }

    public int getRegenAmplifier() {
        return this.regenAmplifier;
    }

    public boolean isDashParticleEnabled() {
        return this.dashParticleEnabled;
    }

    public Particle getDashParticle() {
        return this.dashParticle;
    }

    public int getDashParticleCount() {
        return this.dashParticleCount;
    }

    public double getDashParticleOffsetX() {
        return this.dashParticleOffsetX;
    }

    public double getDashParticleOffsetY() {
        return this.dashParticleOffsetY;
    }

    public double getDashParticleOffsetZ() {
        return this.dashParticleOffsetZ;
    }

    public double getDashParticleSpeed() {
        return this.dashParticleSpeed;
    }

    public boolean isDashSoundEnabled() {
        return this.dashSoundEnabled;
    }

    public Sound getDashSound() {
        return this.dashSound;
    }

    public float getDashSoundVolume() {
        return this.dashSoundVolume;
    }

    public float getDashSoundPitch() {
        return this.dashSoundPitch;
    }

    public boolean isTrailEnabled() {
        return this.trailEnabled;
    }

    public Particle getTrailParticle() {
        return this.trailParticle;
    }

    public int getTrailParticleCount() {
        return this.trailParticleCount;
    }

    public double getTrailOffsetX() {
        return this.trailOffsetX;
    }

    public double getTrailOffsetY() {
        return this.trailOffsetY;
    }

    public double getTrailOffsetZ() {
        return this.trailOffsetZ;
    }

    public double getTrailSpeed() {
        return this.trailSpeed;
    }

    public int getTrailDurationTicks() {
        return this.trailDurationTicks;
    }

    public int getTrailIntervalTicks() {
        return this.trailIntervalTicks;
    }

    public boolean isDoubleDashEnabled() {
        return this.doubleDashEnabled;
    }

    public long getDoubleDashWindowMs() {
        return this.doubleDashWindowMs;
    }

    public int getDoubleDashFallImmunityTicks() {
        return this.doubleDashFallImmunityTicks;
    }

    public int getTearCustomModelData() {
        return this.tearCustomModelData;
    }

    public boolean isWorldBlacklistedForDrops(String worldName) {
        if (worldName == null) {
            return false;
        }
        return this.dropBlacklistWorlds.contains(worldName.toLowerCase());
    }
}

