/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import com.minico.celestialdash.CelestialDash;
import com.minico.celestialdash.Messages;
import com.minico.celestialdash.TearUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CelestialCommand
implements CommandExecutor {
    private final CelestialDash plugin;
    private final Messages messages;

    public CelestialCommand(CelestialDash plugin, Messages messages) {
        this.plugin = plugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("celestialdash.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            this.plugin.reloadConfig();
            this.plugin.loadSettings();
            this.messages.reload();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CelestialDash configuration reloaded.");
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            int amount;
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found: " + args[1]);
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
                if (amount < 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount. Must be a number > 0.");
                return true;
            }
            target.getInventory().addItem(new ItemStack[]{TearUtils.createCelestialTear(amount)});
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Gave " + amount + " Celestial Tears to " + target.getName());
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage:");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " /" + label + " reload");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " /" + label + " give <player> <amount>");
        return true;
    }
}

