/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import com.minico.celestialdash.CelestialDash;
import com.minico.celestialdash.Messages;
import com.minico.celestialdash.TearUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DashHandler
implements Listener {
    private final CelestialDash plugin;
    private final Messages messages;
    private final Map<UUID, Long> lastDash = new HashMap<UUID, Long>();
    private final Map<UUID, Long> comboWindowEnd = new HashMap<UUID, Long>();
    private final Map<UUID, Long> fallImmunityUntil = new HashMap<UUID, Long>();

    public DashHandler(CelestialDash plugin, Messages messages) {
        this.plugin = plugin;
        this.messages = messages;
    }

    @EventHandler
    public void onPlayerUseTear(PlayerInteractEvent event) {
        long cd;
        long last;
        long diff;
        Long windowEnd;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (!TearUtils.isCelestialTear(mainHand)) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean doubleDashEnabled = this.plugin.isDoubleDashEnabled();
        boolean isSecondDash = false;
        if (doubleDashEnabled && (windowEnd = this.comboWindowEnd.get(uuid)) != null) {
            if (now <= windowEnd) {
                isSecondDash = true;
            } else {
                this.comboWindowEnd.remove(uuid);
            }
        }
        if (!isSecondDash && (diff = now - (last = this.lastDash.getOrDefault(uuid, 0L).longValue())) < (cd = this.plugin.getDashCooldownMs())) {
            long remaining = (cd - diff) / 1000L;
            if (remaining < 1L) {
                remaining = 1L;
            }
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)this.messages.formatCooldown(remaining)));
            return;
        }
        int slot = TearUtils.findTearSlot(player);
        if (slot == -1) {
            return;
        }
        TearUtils.consumeTear(player, slot);
        if (isSecondDash) {
            this.performDash(player, true);
            this.applyFallImmunity(uuid);
            this.comboWindowEnd.remove(uuid);
        } else {
            this.performDash(player, false);
            if (doubleDashEnabled) {
                long windowMs = this.plugin.getDoubleDashWindowMs();
                this.comboWindowEnd.put(uuid, now + windowMs);
            }
        }
        this.lastDash.put(uuid, now);
    }

    private void applyFallImmunity(UUID uuid) {
        int ticks = this.plugin.getDoubleDashFallImmunityTicks();
        if (ticks <= 0) {
            return;
        }
        long durationMs = (long)ticks * 50L;
        this.fallImmunityUntil.put(uuid, System.currentTimeMillis() + durationMs);
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        UUID uuid = player.getUniqueId();
        Long until = this.fallImmunityUntil.get(uuid);
        if (until == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now <= until) {
            event.setCancelled(true);
        }
        this.fallImmunityUntil.remove(uuid);
    }

    private void performDash(Player player, boolean secondDash) {
        Vector dir = player.getLocation().getDirection().normalize();
        double strength = this.plugin.getDashStrength();
        double lift = this.plugin.getDashLift();
        if (secondDash) {
            strength *= 1.2;
            lift *= 1.1;
        }
        Vector velocity = dir.multiply(strength);
        velocity.setY(lift);
        player.setVelocity(velocity);
        if (this.plugin.getRegenDurationTicks() > 0) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, this.plugin.getRegenDurationTicks(), this.plugin.getRegenAmplifier(), false, true, true));
        }
        if (this.plugin.isDashParticleEnabled()) {
            player.getWorld().spawnParticle(this.plugin.getDashParticle(), player.getLocation(), this.plugin.getDashParticleCount(), this.plugin.getDashParticleOffsetX(), this.plugin.getDashParticleOffsetY(), this.plugin.getDashParticleOffsetZ(), this.plugin.getDashParticleSpeed());
        }
        if (this.plugin.isDashSoundEnabled()) {
            player.getWorld().playSound(player.getLocation(), this.plugin.getDashSound(), this.plugin.getDashSoundVolume(), this.plugin.getDashSoundPitch());
        }
        if (this.plugin.isTrailEnabled() && this.plugin.getTrailDurationTicks() > 0 && this.plugin.getTrailIntervalTicks() > 0) {
            final UUID uuid = player.getUniqueId();
            new BukkitRunnable(){
                int ticks = 0;

                public void run() {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p == null || !p.isOnline() || this.ticks >= DashHandler.this.plugin.getTrailDurationTicks()) {
                        this.cancel();
                        return;
                    }
                    Location back = p.getLocation().clone().subtract(p.getLocation().getDirection().normalize().multiply(0.5));
                    p.getWorld().spawnParticle(DashHandler.this.plugin.getTrailParticle(), back, DashHandler.this.plugin.getTrailParticleCount(), DashHandler.this.plugin.getTrailOffsetX(), DashHandler.this.plugin.getTrailOffsetY(), DashHandler.this.plugin.getTrailOffsetZ(), DashHandler.this.plugin.getTrailSpeed());
                    this.ticks += DashHandler.this.plugin.getTrailIntervalTicks();
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, (long)this.plugin.getTrailIntervalTicks());
        }
        if (secondDash) {
            player.sendMessage(this.messages.getSecondDashMessage());
        } else {
            player.sendMessage(this.messages.getDashUsedMessage());
        }
    }

    public long getRemainingCooldownSeconds(Player player) {
        long cd;
        long last;
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        long diff = now - (last = this.lastDash.getOrDefault(uuid, 0L).longValue());
        if (diff >= (cd = this.plugin.getDashCooldownMs())) {
            return 0L;
        }
        long remainingMs = cd - diff;
        long seconds = remainingMs / 1000L;
        return Math.max(seconds, 1L);
    }

    public boolean isInDoubleDashWindow(Player player) {
        UUID uuid = player.getUniqueId();
        Long windowEnd = this.comboWindowEnd.get(uuid);
        if (windowEnd == null) {
            return false;
        }
        return System.currentTimeMillis() <= windowEnd;
    }
}

