/*
 * Decompiled with CFR 0.152.
 */
package com.minico.celestialdash;

import com.minico.celestialdash.CelestialDash;
import com.minico.celestialdash.Messages;
import com.minico.celestialdash.TearUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CelestialCommand
implements CommandExecutor {
    private final CelestialDash plugin;
    private final Messages messages;

    public CelestialCommand(CelestialDash plugin, Messages messages) {
        this.plugin = plugin;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("celestialdash.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "CelestialDash Commands:");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "/" + label + " give <player> <amount>");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "/" + label + " reload");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.plugin.reloadConfig();
            this.plugin.loadSettings();
            TearUtils.setCustomModelData(this.plugin.getConfig().getInt("tear-custom-model-data", 0));
            this.messages.reload();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CelestialDash configuration reloaded.");
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            int amount;
            if (args.length < 3) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + label + " give <player> <amount>");
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be a number.");
                return true;
            }
            if (amount <= 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be greater than 0.");
                return true;
            }
            for (int i = 0; i < amount; ++i) {
                target.getInventory().addItem(new ItemStack[]{TearUtils.createCelestialTear()});
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Gave " + amount + " Celestial Tears to " + target.getName() + ".");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use /" + label + " for help.");
        return true;
    }
}

