/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.util;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.google.common.io.ByteArrayDataOutput;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.util.ByteArrayUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    private EntityUtil() {
    }

    public static List<PolarChunk.Entity> getEntities(byte @Nullable [] userData) {
        if (userData == null) {
            return List.of();
        }
        ByteBuffer bb = ByteBuffer.wrap(userData);
        bb.get();
        ArrayList<PolarChunk.Entity> polarEntities = new ArrayList<PolarChunk.Entity>();
        int entityCount = ByteArrayUtil.getVarInt(bb);
        for (int i = 0; i < entityCount; ++i) {
            double x = bb.getDouble();
            double y = bb.getDouble();
            double z = bb.getDouble();
            float yaw = bb.getFloat();
            float pitch = bb.getFloat();
            byte[] bytes = ByteArrayUtil.getByteArray(bb);
            polarEntities.add(new PolarChunk.Entity(x, y, z, yaw, pitch, bytes));
        }
        return polarEntities;
    }

    public static void writeEntities(List<PolarChunk.Entity> entities, @NotNull ByteArrayDataOutput data) {
        ByteArrayUtil.writeVarInt(entities.size(), data);
        for (PolarChunk.Entity entity : entities) {
            data.writeDouble(entity.x());
            data.writeDouble(entity.y());
            data.writeDouble(entity.z());
            data.writeFloat(entity.yaw());
            data.writeFloat(entity.pitch());
            ByteArrayUtil.writeByteArray(entity.bytes(), data);
        }
    }

    @Nullable
    public static Entity bytesToEntity(World world, byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        DataInputStream dataInput = new DataInputStream(inputStream);
        CompoundTag compound = NbtIo.read((DataInput)dataInput, (NbtAccounter)NbtAccounter.unlimitedHeap());
        Optional dataVersion = compound.getInt("DataVersion");
        compound = PlatformHooks.get().convertNBT(References.ENTITY, MinecraftServer.getServer().fixerUpper, compound, ((Integer)dataVersion.get()).intValue(), Bukkit.getUnsafe().getDataVersion());
        ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "deserialiseEntity", LogUtils.getLogger());
        ValueInput tagValueInput = TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)((CraftWorld)world).getHandle().registryAccess(), (CompoundTag)compound);
        Optional entityOptional = net.minecraft.world.entity.EntityType.create((ValueInput)tagValueInput, (Level)((CraftWorld)world).getHandle(), (EntitySpawnReason)EntitySpawnReason.LOAD);
        if (entityOptional.isEmpty()) {
            return null;
        }
        return ((net.minecraft.world.entity.Entity)entityOptional.get()).getBukkitEntity();
    }

    public static byte @Nullable [] entityToBytes(Entity entity) {
        if (entity.getType() == EntityType.PLAYER) {
            return null;
        }
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "serialiseEntity@" + String.valueOf(entity.getUniqueId()), LogUtils.getLogger());
        TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)problemReporter, (HolderLookup.Provider)nmsEntity.registryAccess());
        boolean successful = ((CraftEntity)entity).getHandle().saveAsPassenger((ValueOutput)tagValueOutput, true, false, false);
        CompoundTag compound = tagValueOutput.buildResult();
        Optional id = compound.getString("id");
        if (id.isEmpty() || ((String)id.get()).isBlank() || !successful) {
            return null;
        }
        compound.putInt("DataVersion", Bukkit.getUnsafe().getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        try {
            NbtIo.write((CompoundTag)compound, (DataOutput)dataOutput);
            outputStream.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }
}

