/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.ChunkSelector;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SaveCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        return SaveCommand.save(ctx, ChunkSelector.all());
    }

    protected static int runSelected(CommandContext<CommandSourceStack> ctx) {
        Integer chunkRadius = (Integer)ctx.getArgument("chunkradius", Integer.class);
        return SaveCommand.save(ctx, ChunkSelector.square(0, 0, chunkRadius));
    }

    protected static int runSelectedCentered(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            sender.sendMessage("Run this command as a player to center the radius around you, otherwise run without centered to center it around 0,0");
            return 1;
        }
        Player player = (Player)sender;
        Integer chunkRadius = (Integer)ctx.getArgument("chunkradius", Integer.class);
        Chunk playerChunk = player.getChunk();
        int offsetX = playerChunk.getX();
        int offsetZ = playerChunk.getZ();
        return SaveCommand.save(ctx, ChunkSelector.square(offsetX, offsetZ, chunkRadius));
    }

    protected static int save(CommandContext<CommandSourceStack> ctx, ChunkSelector chunkSelector) {
        String worldName = (String)ctx.getArgument("worldname", String.class);
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' does not exist!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (polarWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is not a polar world!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Saving '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.AQUA)));
        long before = System.nanoTime();
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> Polar.saveWorldConfigSource(bukkitWorld, polarWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, chunkSelector, 0, 0).thenAccept(successful -> {
            if (successful.booleanValue()) {
                int ms = (int)((System.nanoTime() - before) / 1000000L);
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Saved '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms", (TextColor)NamedTextColor.AQUA)));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Something went wrong while trying to save '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.RED)));
            }
        }));
        return 1;
    }
}

