/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.World;

public class ReloadConfigCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        PolarPaper.getPlugin().reloadConfig();
        for (World bukkitWorld : Bukkit.getWorlds()) {
            Config config;
            PolarGenerator generator;
            PolarWorld world;
            if (!Polar.isInConfig(bukkitWorld.getName()) || (world = PolarWorld.fromWorld(bukkitWorld)) == null || (generator = PolarGenerator.fromWorld(bukkitWorld)) == null || (config = Config.readFromConfig(PolarPaper.getPlugin().getConfig(), bukkitWorld.getName())) == null) continue;
            generator.setConfig(config);
            bukkitWorld.setDifficulty(Difficulty.valueOf((String)config.difficulty().name()));
            bukkitWorld.setSpawnFlags(config.allowMonsters(), config.allowAnimals());
            bukkitWorld.setAutoSave(false);
            for (Config.GameRule gamerule : config.gamerules()) {
                GameRule rule = GameRule.getByName((String)gamerule.name());
                if (rule == null) continue;
                Polar.setGameRule(bukkitWorld, rule, gamerule.value());
            }
            Polar.startAutoSaveTask(bukkitWorld, config);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Reloaded config for ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.AQUA)));
        }
        return 1;
    }
}

