/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWriter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class CreateBlankCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        String worldName = (String)ctx.getArgument("worldname", String.class);
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld != null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' already exists!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        byte[] polarBytes = PolarWriter.write(new PolarWorld());
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        try {
            Files.write(worldsFolder.resolve(worldName + ".polar"), polarBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Failed to create world '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED)));
            PolarPaper.logger().warning("Error while creating blank world " + worldName);
            PolarPaper.logger().warning(e.toString());
            return 1;
        }
        Config.writeToConfig(PolarPaper.getPlugin().getConfig(), worldName, Config.DEFAULT);
        Polar.loadWorld(new PolarWorld(), worldName, Config.DEFAULT);
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Created blank world '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.AQUA)));
        return 1;
    }
}

