/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import com.github.luben.zstd.Zstd;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarDataConverter;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.util.ByteArrayUtil;
import live.minehub.polarpaper.util.PaletteUtil;
import org.jetbrains.annotations.NotNull;

public class PolarWriter {
    private static final int CHUNK_SECTION_SIZE = 16;

    private PolarWriter() {
    }

    public static byte[] write(@NotNull PolarWorld world) {
        return PolarWriter.write(world, PolarDataConverter.DEFAULT);
    }

    public static byte[] write(@NotNull PolarWorld world, @NotNull PolarDataConverter dataConverter) {
        ByteArrayDataOutput bb = ByteStreams.newDataOutput();
        bb.write((int)world.minSection());
        bb.write((int)world.maxSection());
        ByteArrayUtil.writeVarInt(world.userData().length, bb);
        bb.write(world.userData());
        ByteArrayUtil.writeVarInt(world.nonEmptyChunks(), bb);
        for (PolarChunk chunk : world.chunks()) {
            if (chunk.isEmpty()) continue;
            PolarWriter.writeChunk(bb, chunk, world.maxSection() - world.minSection() + 1);
        }
        byte[] contentBytes = bb.toByteArray();
        ByteArrayDataOutput finalBB = ByteStreams.newDataOutput();
        finalBB.writeInt(1349479538);
        finalBB.writeShort(7);
        ByteArrayUtil.writeVarInt(dataConverter.dataVersion(), finalBB);
        finalBB.write(world.compression().ordinal());
        switch (world.compression()) {
            case NONE: {
                ByteArrayUtil.writeVarInt(contentBytes.length, finalBB);
                finalBB.write(contentBytes);
                break;
            }
            case ZSTD: {
                ByteArrayUtil.writeVarInt(contentBytes.length, finalBB);
                finalBB.write(Zstd.compress((byte[])contentBytes));
            }
        }
        return finalBB.toByteArray();
    }

    private static void writeChunk(@NotNull ByteArrayDataOutput bb, @NotNull PolarChunk chunk, int sectionCount) {
        ByteArrayUtil.writeVarInt(chunk.x(), bb);
        ByteArrayUtil.writeVarInt(chunk.z(), bb);
        assert (sectionCount == chunk.sections().length) : "section count and chunk section length mismatch";
        for (PolarSection section : chunk.sections()) {
            PolarWriter.writeSection(bb, section);
        }
        ByteArrayUtil.writeVarInt(chunk.blockEntities().size(), bb);
        for (PolarChunk.BlockEntity blockEntity : chunk.blockEntities()) {
            ByteArrayUtil.writeBlockEntity(bb, blockEntity);
        }
        int heightmapBits = 0;
        for (int i = 0; i < 32; ++i) {
            if (chunk.heightmap(i) == null) continue;
            heightmapBits |= 1 << i;
        }
        bb.writeInt(heightmapBits);
        int bitsPerEntry = PaletteUtil.bitsToRepresent(sectionCount * 16);
        for (int i = 0; i < 32; ++i) {
            int[] heightmap = chunk.heightmap(i);
            if (heightmap == null) continue;
            if (heightmap.length == 0) {
                ByteArrayUtil.writeLongArray(new long[0], bb);
                continue;
            }
            ByteArrayUtil.writeLongArray(PaletteUtil.pack(heightmap, bitsPerEntry), bb);
        }
        ByteArrayUtil.writeByteArray(chunk.userData(), bb);
    }

    private static void writeSection(@NotNull ByteArrayDataOutput bb, @NotNull PolarSection section) {
        bb.write(section.isEmpty() ? 1 : 0);
        if (section.isEmpty()) {
            return;
        }
        String[] blockPalette = section.blockPalette();
        ByteArrayUtil.writeStringArray(blockPalette, bb);
        if (blockPalette.length > 1) {
            int[] blockData = section.blockData();
            int bitsPerEntry = (int)Math.ceil(Math.log(blockPalette.length) / Math.log(2.0));
            if (bitsPerEntry < 1) {
                bitsPerEntry = 1;
            }
            ByteArrayUtil.writeLongArray(PaletteUtil.pack(blockData, bitsPerEntry), bb);
        }
        String[] biomePalette = section.biomePalette();
        ByteArrayUtil.writeStringArray(biomePalette, bb);
        if (biomePalette.length > 1) {
            int[] biomeData = section.biomeData();
            int bitsPerEntry = (int)Math.ceil(Math.log(biomePalette.length) / Math.log(2.0));
            if (bitsPerEntry < 1) {
                bitsPerEntry = 1;
            }
            ByteArrayUtil.writeLongArray(PaletteUtil.pack(biomeData, bitsPerEntry), bb);
        }
        bb.write((int)((byte)section.blockLightContent().ordinal()));
        if (section.blockLightContent() == PolarSection.LightContent.PRESENT) {
            bb.write(section.blockLight());
        }
        bb.write((int)((byte)section.skyLightContent().ordinal()));
        if (section.skyLightContent() == PolarSection.LightContent.PRESENT) {
            bb.write(section.skyLight());
        }
    }
}

