/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import java.util.Random;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.util.CoordConversion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.generator.CraftChunkData;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarGenerator
extends ChunkGenerator {
    private static final int CHUNK_SECTION_SIZE = 16;
    private final PolarWorld polarWorld;
    private final PolarWorldAccess worldAccess;
    private Config config;

    public PolarGenerator(PolarWorld polarWorld, Config config) {
        this(polarWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, config);
    }

    public PolarGenerator(PolarWorld polarWorld, PolarWorldAccess worldAccess, Config config) {
        this.polarWorld = polarWorld;
        this.worldAccess = worldAccess;
        this.config = config;
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        PolarChunk chunk = this.polarWorld.chunkAt(chunkX, chunkZ);
        if (chunk == null) {
            if (!this.config.allowWorldExpansion()) {
                return;
            }
            this.polarWorld.addExpandChunk(chunkX, chunkZ);
            return;
        }
        int i = 0;
        for (PolarSection section : chunk.sections()) {
            int yLevel = chunkData.getMinHeight() + i++ * 16;
            this.loadSection(section, yLevel, chunkData);
        }
        for (PolarChunk.BlockEntity blockEntity : chunk.blockEntities()) {
            this.loadBlockEntity(blockEntity, chunkData, chunkX, chunkZ);
        }
        this.worldAccess.loadHeightmaps(chunkData, chunk.heightmaps());
        if (chunk.userData().length > 0) {
            this.worldAccess.loadChunkData(chunkData, chunk.userData());
        }
    }

    private void loadBlockEntity(@NotNull PolarChunk.BlockEntity polarBlockEntity, @NotNull ChunkGenerator.ChunkData chunkData, int chunkX, int chunkZ) {
        RegistryAccess.Frozen registryAccess;
        BlockState blockState;
        BlockPos blockPos;
        BlockEntity blockEntity;
        CompoundTag compoundTag = polarBlockEntity.data();
        if (compoundTag == null) {
            return;
        }
        int x = CoordConversion.chunkBlockIndexGetX(polarBlockEntity.index());
        int y = CoordConversion.chunkBlockIndexGetY(polarBlockEntity.index());
        int z = CoordConversion.chunkBlockIndexGetZ(polarBlockEntity.index());
        BlockData blockData = chunkData.getBlockData(x, y, z);
        if (polarBlockEntity.id() != null) {
            compoundTag.putString("id", polarBlockEntity.id());
        }
        if ((blockEntity = BlockEntity.loadStatic((BlockPos)(blockPos = new BlockPos(chunkX * 16 + x, y, chunkZ * 16 + z)), (BlockState)(blockState = ((CraftBlockState)blockData.createBlockState()).getHandle()), (CompoundTag)compoundTag, (HolderLookup.Provider)(registryAccess = ((CraftServer)Bukkit.getServer()).getServer().registryAccess()))) == null) {
            return;
        }
        ((CraftChunkData)chunkData).getHandle().blockEntities.put(blockPos, blockEntity);
    }

    private void loadSection(@NotNull PolarSection section, int yLevel, @NotNull ChunkGenerator.ChunkData chunkData) {
        String[] rawBlockPalette = section.blockPalette();
        BlockData[] materialPalette = new BlockData[rawBlockPalette.length];
        for (int i = 0; i < rawBlockPalette.length; ++i) {
            try {
                materialPalette[i] = Bukkit.getServer().createBlockData(rawBlockPalette[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                PolarPaper.logger().warning("Failed to parse block state: " + rawBlockPalette[i]);
                materialPalette[i] = Bukkit.getServer().createBlockData("minecraft:air");
            }
        }
        if (materialPalette.length == 1) {
            BlockData material = materialPalette[0];
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        chunkData.setBlock(x, yLevel + y, z, material);
                    }
                }
            }
        } else {
            int[] blockData = section.blockData();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        int index = y * 16 * 16 + z * 16 + x;
                        BlockData material = materialPalette[blockData[index]];
                        chunkData.setBlock(x, yLevel + y, z, material);
                    }
                }
            }
        }
    }

    public PolarWorld getPolarWorld() {
        return this.polarWorld;
    }

    public PolarWorldAccess getWorldAccess() {
        return this.worldAccess;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    @Nullable
    public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
        Location loc = this.config.spawn();
        loc.setWorld(world);
        return loc;
    }

    @Nullable
    public static PolarGenerator fromWorld(World world) {
        ChunkGenerator generator = world.getGenerator();
        if (!(generator instanceof PolarGenerator)) {
            return null;
        }
        PolarGenerator polarGenerator = (PolarGenerator)generator;
        return polarGenerator;
    }
}

