/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import java.util.Arrays;
import java.util.List;
import live.minehub.polarpaper.PolarSection;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public record PolarChunk(int x, int z, PolarSection[] sections, List<BlockEntity> blockEntities, int[][] heightmaps, byte[] userData) {
    public static final int HEIGHTMAP_NONE = 0;
    public static final int HEIGHTMAP_MOTION_BLOCKING = 1;
    public static final int HEIGHTMAP_MOTION_BLOCKING_NO_LEAVES = 2;
    public static final int HEIGHTMAP_OCEAN_FLOOR = 4;
    public static final int HEIGHTMAP_OCEAN_FLOOR_WG = 8;
    public static final int HEIGHTMAP_WORLD_SURFACE = 16;
    public static final int HEIGHTMAP_WORLD_SURFACE_WG = 32;
    static final int[] HEIGHTMAPS = new int[]{0, 1, 2, 4, 8, 16, 32};
    static final int HEIGHTMAP_SIZE = 256;
    static final int MAX_HEIGHTMAPS = 32;

    public PolarChunk(int x, int z, int sectionCount) {
        this(x, z, new PolarSection[sectionCount], List.of(), new int[32][0], new byte[0]);
        Arrays.setAll(this.sections, i -> new PolarSection());
    }

    public int @Nullable [] heightmap(int type) {
        return this.heightmaps[type];
    }

    public boolean isEmpty() {
        for (PolarSection section : this.sections) {
            if (section.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public record Entity(double x, double y, double z, float yaw, float pitch, byte[] bytes) {
    }

    public record BlockEntity(int index, @Nullable String id, @Nullable CompoundTag data) {
    }
}

