/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.world.PaperWorldLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import live.minehub.polarpaper.ChunkSelector;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarBiomeProvider;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarReader;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarServerLevel;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.PolarWriter;
import live.minehub.polarpaper.source.PolarSource;
import live.minehub.polarpaper.util.CoordConversion;
import live.minehub.polarpaper.util.ExceptionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Main;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Polar {
    private static final Map<String, BukkitTask> AUTOSAVE_TASK_MAP = new HashMap<String, BukkitTask>();

    private Polar() {
    }

    public static boolean isInConfig(@NotNull String worldName) {
        return PolarPaper.getPlugin().getConfig().isSet("worlds." + worldName);
    }

    public static void loadWorld(@NotNull PolarWorld world, @NotNull String worldName) {
        Polar.loadWorld(world, worldName, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static void loadWorld(@NotNull PolarWorld world, @NotNull String worldName, @NotNull Config config) {
        Polar.loadWorld(world, worldName, config, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static void loadWorld(@NotNull PolarWorld world, @NotNull String worldName, @NotNull PolarWorldAccess worldAccess) {
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config config = Config.readFromConfig(fileConfig, worldName);
        if (config == null) {
            PolarPaper.logger().warning("Polar world '" + worldName + "' has an invalid config");
            return;
        }
        Polar.loadWorld(world, worldName, config, worldAccess);
    }

    public static void loadWorld(@NotNull PolarWorld world, @NotNull String worldName, @NotNull Config config, @NotNull PolarWorldAccess worldAccess) {
        if (Bukkit.getWorld((String)worldName) != null) {
            PolarPaper.logger().warning("A world with the name '" + worldName + "' already exists, skipping.");
            return;
        }
        PolarGenerator polar = new PolarGenerator(world, worldAccess, config);
        PolarBiomeProvider polarBiomeProvider = new PolarBiomeProvider(world);
        WorldCreator worldCreator = WorldCreator.name((String)worldName).type(config.worldType()).environment(config.environment()).generator((ChunkGenerator)polar).biomeProvider((BiomeProvider)polarBiomeProvider);
        World newWorld = Polar.loadWorld(worldCreator, config.difficulty(), config.gamerules(), config.allowMonsters(), config.allowAnimals());
        if (newWorld == null) {
            PolarPaper.logger().warning("An error occurred loading polar world '" + worldName + "', skipping.");
            return;
        }
        Polar.startAutoSaveTask(newWorld, config);
    }

    public static void startAutoSaveTask(World newWorld, Config config) {
        if (config.autoSaveIntervalTicks() == -1) {
            return;
        }
        BukkitTask prevTask = AUTOSAVE_TASK_MAP.get(newWorld.getName());
        if (prevTask != null) {
            prevTask.cancel();
        }
        BukkitTask autosaveTask = Bukkit.getScheduler().runTaskTimer((Plugin)PolarPaper.getPlugin(), () -> {
            long before = System.nanoTime();
            String savingMsg = String.format("Autosaving '%s'...", newWorld.getName());
            PolarPaper.logger().info(savingMsg);
            for (Player plr : Bukkit.getOnlinePlayers()) {
                if (!plr.hasPermission("polar.notifications")) continue;
                plr.sendMessage((Component)Component.text((String)savingMsg, (TextColor)NamedTextColor.AQUA));
            }
            Polar.saveWorldConfigSource(newWorld).thenRun(() -> {
                int ms = (int)((System.nanoTime() - before) / 1000000L);
                String savedMsg = String.format("Saved '%s' in %sms", newWorld.getName(), ms);
                PolarPaper.logger().info(savedMsg);
                for (Player plr : Bukkit.getOnlinePlayers()) {
                    if (!plr.hasPermission("polar.notifications")) continue;
                    plr.sendMessage((Component)Component.text((String)savedMsg, (TextColor)NamedTextColor.AQUA));
                }
            });
        }, (long)config.autoSaveIntervalTicks(), (long)config.autoSaveIntervalTicks());
        AUTOSAVE_TASK_MAP.put(newWorld.getName(), autosaveTask);
    }

    public static <T> void setGameRule(World world, GameRule<?> rule, Object value) {
        world.setGameRule(rule, value);
    }

    public static Config updateConfig(World world, String worldName) {
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config config = Config.readFromConfig(fileConfig, worldName);
        if (config == null) {
            return Config.DEFAULT;
        }
        ArrayList<Config.GameRule> gameruleList = new ArrayList<Config.GameRule>();
        for (String name : world.getGameRules()) {
            Object gameRuleDefault;
            Object gameRuleValue;
            GameRule gamerule = GameRule.getByName((String)name);
            if (gamerule == null || (gameRuleValue = world.getGameRuleValue(gamerule)) == null || gameRuleValue == (gameRuleDefault = world.getGameRuleDefault(gamerule))) continue;
            gameruleList.add(new Config.GameRule(name, gameRuleValue));
        }
        Config newConfig = new Config(config.source(), config.autoSaveIntervalTicks(), config.saveOnStop(), config.loadOnStartup(), config.spawn(), Difficulty.valueOf((String)world.getDifficulty().name()), world.getAllowMonsters(), world.getAllowAnimals(), config.allowWorldExpansion(), config.worldType(), config.environment(), gameruleList);
        Config.writeToConfig(fileConfig, worldName, newConfig);
        return newConfig;
    }

    public static CompletableFuture<Boolean> loadWorldConfigSource(@NotNull String worldName) {
        return Polar.loadWorldConfigSource(worldName, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static CompletableFuture<Boolean> loadWorldConfigSource(@NotNull String worldName, @NotNull PolarWorldAccess worldAccess) {
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config config = Config.readFromConfig(fileConfig, worldName);
        if (config == null) {
            PolarPaper.logger().warning("Polar world '" + worldName + "' has an invalid config, skipping.");
            return CompletableFuture.completedFuture(false);
        }
        PolarSource source = PolarSource.fromConfig(worldName, config);
        if (source == null) {
            PolarPaper.logger().warning("Source " + config.source() + " not recognised");
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
            try {
                byte[] bytes = source.readBytes();
                PolarWorld polarWorld = PolarReader.read(bytes);
                if (polarWorld.version() == 8) {
                    PolarPaper.logger().info("Re-saving world to update legacy entities");
                    byte[] worldBytes = PolarWriter.write(polarWorld);
                    source.saveBytes(worldBytes);
                }
                Bukkit.getScheduler().runTask((Plugin)PolarPaper.getPlugin(), () -> {
                    Polar.loadWorld(polarWorld, worldName, config, worldAccess);
                    future.complete(true);
                });
            }
            catch (Exception e) {
                ExceptionUtil.log(e);
                future.complete(false);
            }
        });
        return future;
    }

    public static CompletableFuture<Boolean> saveWorldConfigSource(World world) {
        PolarWorld polarWorld = PolarWorld.fromWorld(world);
        if (polarWorld == null) {
            return CompletableFuture.completedFuture(false);
        }
        PolarGenerator generator = PolarGenerator.fromWorld(world);
        if (generator == null) {
            return CompletableFuture.completedFuture(false);
        }
        return Polar.saveWorldConfigSource(world, polarWorld, generator.getWorldAccess(), ChunkSelector.all(), 0, 0);
    }

    public static CompletableFuture<Boolean> saveWorldConfigSource(World world, PolarWorld polarWorld, PolarWorldAccess polarWorldAccess, ChunkSelector chunkSelector, int offsetX, int offsetZ) {
        Config newConfig = Polar.updateConfig(world, world.getName());
        PolarSource source = PolarSource.fromConfig(world.getName(), newConfig);
        if (source == null) {
            PolarPaper.logger().warning("Source " + newConfig.source() + " not recognised");
            return CompletableFuture.completedFuture(false);
        }
        return Polar.saveWorld(world, polarWorld, polarWorldAccess, source, chunkSelector, offsetX, offsetZ);
    }

    public static CompletableFuture<Boolean> saveWorld(World world, PolarWorld polarWorld, PolarWorldAccess polarWorldAccess, PolarSource polarSource, ChunkSelector chunkSelector, int offsetX, int offsetZ) {
        return ((CompletableFuture)Polar.updateWorld(world, polarWorld, polarWorldAccess, chunkSelector, offsetX, offsetZ).thenApply(a -> {
            byte[] worldBytes = PolarWriter.write(polarWorld);
            polarSource.saveBytes(worldBytes);
            return true;
        })).exceptionally(e -> {
            ExceptionUtil.log(e);
            return false;
        });
    }

    public static CompletableFuture<Boolean> saveWorld(World world, PolarSource polarSource) {
        PolarWorld polarWorld = PolarWorld.fromWorld(world);
        if (polarWorld == null) {
            return CompletableFuture.completedFuture(false);
        }
        PolarGenerator generator = PolarGenerator.fromWorld(world);
        if (generator == null) {
            return CompletableFuture.completedFuture(false);
        }
        return Polar.saveWorld(world, polarWorld, generator.getWorldAccess(), polarSource, ChunkSelector.all(), 0, 0);
    }

    public static void saveWorldSync(World world, PolarWorld polarWorld, PolarWorldAccess polarWorldAccess, PolarSource polarSource, ChunkSelector chunkSelector, int offsetX, int offsetZ) {
        Polar.updateWorldSync(world, polarWorld, polarWorldAccess, chunkSelector, offsetX, offsetZ);
        byte[] worldBytes = PolarWriter.write(polarWorld);
        polarSource.saveBytes(worldBytes);
    }

    public static CompletableFuture<Void> updateWorld(World world, PolarWorld polarWorld, PolarWorldAccess polarWorldAccess, ChunkSelector chunkSelector, int offsetX, int offsetZ) {
        ArrayList<Long> chunkIndices = new ArrayList<Long>((Collection<Long>)polarWorld.expandChunks());
        for (PolarChunk chunk : polarWorld.chunks()) {
            chunkIndices.add(CoordConversion.chunkIndex(chunk.x(), chunk.z()));
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(chunkIndices.size());
        for (Long chunkIndex : chunkIndices) {
            int chunkZ;
            int chunkX = CoordConversion.chunkX(chunkIndex);
            if (!chunkSelector.test(chunkX, chunkZ = CoordConversion.chunkZ(chunkIndex))) {
                polarWorld.removeChunkAt(chunkX, chunkZ);
                continue;
            }
            CompletionStage future = ((CompletableFuture)world.getChunkAtAsync(chunkX + offsetX, chunkZ + offsetZ).thenAcceptAsync(c -> Polar.updateChunkData(polarWorld, polarWorldAccess, c, chunkX, chunkZ).join())).exceptionally(e -> {
                PolarPaper.logger().warning(e.toString());
                return null;
            });
            futures.add(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public static void updateWorldSync(World world, PolarWorld polarWorld, PolarWorldAccess polarWorldAccess, ChunkSelector chunkSelector, int offsetX, int offsetZ) {
        ArrayList<Long> chunkIndices = new ArrayList<Long>((Collection<Long>)polarWorld.expandChunks());
        for (PolarChunk chunk : polarWorld.chunks()) {
            chunkIndices.add(CoordConversion.chunkIndex(chunk.x(), chunk.z()));
        }
        for (Long chunkIndex : chunkIndices) {
            int chunkZ;
            int chunkX = CoordConversion.chunkX(chunkIndex);
            if (!chunkSelector.test(chunkX, chunkZ = CoordConversion.chunkZ(chunkIndex))) {
                polarWorld.removeChunkAt(chunkX, chunkZ);
                continue;
            }
            Chunk c = world.getChunkAt(chunkX + offsetX, chunkZ + offsetZ);
            Polar.updateChunkData(polarWorld, polarWorldAccess, c, chunkX, chunkZ).join();
        }
    }

    @Nullable
    public static World loadWorld(WorldCreator creator, Difficulty difficulty, List<Config.GameRule> gamerules, boolean allowMonsters, boolean allowAnimals) {
        String levelName;
        PrimaryLevelData primaryLevelData;
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        if (craftServer.getWorld(creator.name()) != null) {
            return null;
        }
        Preconditions.checkState((boolean)craftServer.getServer().getAllLevels().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        Preconditions.checkArgument((creator != null ? 1 : 0) != 0, (Object)"WorldCreator cannot be null");
        String name = creator.name();
        ChunkGenerator chunkGenerator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(craftServer.getWorldContainer(), name);
        World world = craftServer.getWorld(name);
        World worldByKey = craftServer.getWorld(creator.key());
        if (world != null || worldByKey != null) {
            if (world == worldByKey) {
                return world;
            }
            throw new IllegalArgumentException("Cannot create a world with key " + String.valueOf(creator.key()) + " and name " + name + " one (or both) already match a world that exists");
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)name);
        }
        if (chunkGenerator == null) {
            chunkGenerator = craftServer.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = craftServer.getBiomeProvider(name);
        }
        ResourceKey actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> LevelStem.OVERWORLD;
            case World.Environment.NETHER -> LevelStem.NETHER;
            case World.Environment.THE_END -> LevelStem.END;
            default -> throw new IllegalArgumentException("Illegal dimension (" + String.valueOf(creator.environment()) + ")");
        };
        try {
            Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
            Path tempFolder = pluginFolder.resolve("temp");
            levelStorageAccess = LevelStorageSource.createDefault((Path)tempFolder).validateAndCreateAccess(name, actualDimension);
        }
        catch (IOException | ContentValidationException ex) {
            throw new RuntimeException(ex);
        }
        boolean hardcore = creator.hardcore();
        WorldLoader.DataLoadContext context = craftServer.getServer().worldLoaderContext;
        RegistryAccess.Frozen registryAccess = context.datapackDimensions();
        Registry contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        Dynamic dataTag = PaperWorldLoader.getLevelData((LevelStorageSource.LevelStorageAccess)levelStorageAccess).dataTag();
        if (dataTag != null) {
            LevelDataAndDimensions levelDataAndDimensions = LevelStorageSource.getLevelDataAndDimensions((Dynamic)dataTag, (WorldDataConfiguration)context.dataConfiguration(), (Registry)contextLevelStemRegistry, (HolderLookup.Provider)context.datapackWorldgen());
            primaryLevelData = (PrimaryLevelData)levelDataAndDimensions.worldData();
            registryAccess = levelDataAndDimensions.dimensions().dimensionsRegistryAccess();
        } else {
            WorldOptions worldOptions = new WorldOptions(creator.seed(), creator.generateStructures(), creator.bonusChest());
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(GsonHelper.parse((String)(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings())), creator.type().name().toLowerCase(Locale.ROOT));
            LevelSettings levelSettings = new LevelSettings(name, GameType.byId((int)craftServer.getDefaultGameMode().getValue()), hardcore, difficulty, false, new GameRules(context.dataConfiguration().enabledFeatures()), context.dataConfiguration());
            WorldDimensions worldDimensions = properties.create(context.datapackWorldgen());
            WorldDimensions.Complete complete = worldDimensions.bake(contextLevelStemRegistry);
            Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
            primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle);
            registryAccess = complete.dimensionsRegistryAccess();
        }
        primaryLevelData.customDimensions = contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        primaryLevelData.checkName(name);
        primaryLevelData.setModdedInfo(craftServer.getServer().getServerModName(), craftServer.getServer().getModdedStatus().shouldReportAsModified());
        if (craftServer.getServer().options.has("forceUpgrade")) {
            Main.forceUpgrade((LevelStorageSource.LevelStorageAccess)levelStorageAccess, (WorldData)primaryLevelData, (DataFixer)DataFixers.getDataFixer(), (boolean)craftServer.getServer().options.has("eraseCache"), () -> true, (RegistryAccess)registryAccess, (boolean)craftServer.getServer().options.has("recreateRegionFiles"));
        }
        long i = BiomeManager.obfuscateSeed((long)primaryLevelData.worldGenOptions().seed());
        ImmutableList list = ImmutableList.of();
        LevelStem customStem = (LevelStem)contextLevelStemRegistry.getValue(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo(primaryLevelData, levelStorageAccess, creator.environment(), (DimensionType)customStem.type().value(), customStem.generator(), craftServer.getHandle().getServer().registryAccess());
        if (biomeProvider == null && chunkGenerator != null) {
            biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ResourceKey dimensionKey = name.equals((levelName = craftServer.getServer().getProperties().levelName) + "_nether") ? Level.NETHER : (name.equals(levelName + "_the_end") ? Level.END : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)creator.key().namespace(), (String)creator.key().value())));
        PolarServerLevel serverLevel = new PolarServerLevel((MinecraftServer)craftServer.getServer(), craftServer.getServer().executor, levelStorageAccess, primaryLevelData, (ResourceKey<Level>)dimensionKey, customStem, primaryLevelData.isDebugWorld(), i, (List<CustomSpawner>)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, craftServer.getServer().overworld().getRandomSequences(), creator.environment(), chunkGenerator, biomeProvider);
        for (Config.GameRule rule : gamerules) {
            GameRules.Value handle = serverLevel.getGameRules().getRule((GameRules.Key)serverLevel.getWorld().getGameRulesNMS().get(rule.name()));
            handle.deserialize(String.valueOf(rule.value()));
            handle.onChanged((ServerLevel)serverLevel);
        }
        craftServer.getServer().addLevel((ServerLevel)serverLevel);
        craftServer.getServer().initWorld((ServerLevel)serverLevel, primaryLevelData, primaryLevelData.worldGenOptions());
        serverLevel.getChunkSource().setSpawnSettings(allowMonsters, allowAnimals);
        craftServer.getServer().prepareLevel((ServerLevel)serverLevel);
        return serverLevel.getWorld();
    }

    public static CompletableFuture<Void> updateChunkData(PolarWorld polarWorld, PolarWorldAccess worldAccess, Chunk chunk, int newChunkX, int newChunkZ) {
        CraftChunk craftChunk = (CraftChunk)chunk;
        if (craftChunk == null) {
            polarWorld.removeChunkAt(newChunkX, newChunkZ);
            return CompletableFuture.completedFuture(null);
        }
        ChunkSnapshot snapshot = craftChunk.getChunkSnapshot(true, true, false, false);
        int minHeight = chunk.getWorld().getMinHeight();
        int maxHeight = chunk.getWorld().getMaxHeight();
        Set blockEntities = craftChunk.getHandle((ChunkStatus)ChunkStatus.FULL).blockEntities.entrySet();
        Entity[] entities = Arrays.copyOf(craftChunk.getEntities(), craftChunk.getEntities().length);
        int worldHeight = maxHeight - minHeight + 1;
        int sectionCount = worldHeight / 16;
        boolean onlyPlayers = true;
        for (Entity entity : entities) {
            if (entity.getType() == EntityType.PLAYER) continue;
            onlyPlayers = false;
            break;
        }
        if (onlyPlayers) {
            boolean allEmpty = true;
            for (int i = 0; i < sectionCount; ++i) {
                if (snapshot.isSectionEmpty(i)) continue;
                allEmpty = false;
                break;
            }
            if (allEmpty) {
                polarWorld.removeChunkAt(newChunkX, newChunkZ);
                polarWorld.addExpandChunk(newChunkX, newChunkZ);
                return CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.runAsync(() -> {
            PolarChunk polarChunk = Polar.createPolarChunk(worldAccess, snapshot, newChunkX, newChunkZ, minHeight, maxHeight, blockEntities, entities);
            polarWorld.updateChunkAt(newChunkX, newChunkZ, polarChunk);
        });
    }

    public static PolarChunk createPolarChunk(PolarWorldAccess worldAccess, ChunkSnapshot snapshot, int newChunkX, int newChunkZ, int minHeight, int maxHeight, Set<Map.Entry<BlockPos, BlockEntity>> blockEntities, Entity[] entities) {
        ArrayList<PolarChunk.BlockEntity> polarBlockEntities = new ArrayList<PolarChunk.BlockEntity>();
        int worldHeight = maxHeight - minHeight + 1;
        int sectionCount = worldHeight / 16;
        PolarSection[] sections = new PolarSection[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            int sectionY = minHeight + i * 16;
            int[] blockData = new int[4096];
            ArrayList<BlockData> blockPalette = new ArrayList<BlockData>();
            ArrayList<String> blockPaletteStrings = new ArrayList<String>();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    int sectionLocalY = sectionY + y;
                    for (int z = 0; z < 16; ++z) {
                        int blockIndex = x + y * 16 * 16 + z * 16;
                        BlockData data = snapshot.getBlockData(x, sectionLocalY, z);
                        int paletteId = blockPalette.indexOf(data);
                        if (paletteId == -1) {
                            paletteId = blockPalette.size();
                            blockPalette.add(data);
                            blockPaletteStrings.add(data.getAsString(true));
                        }
                        blockData[blockIndex] = paletteId;
                    }
                }
            }
            if (blockPalette.size() == 1) {
                blockData = null;
            }
            int[] biomeData = new int[64];
            ArrayList<String> biomePalette = new ArrayList<String>();
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    for (int z = 0; z < 4; ++z) {
                        Biome biome = snapshot.getBiome(x * 4, sectionY + y * 4, z * 4);
                        String biomeString = biome.key().toString();
                        int paletteId = biomePalette.indexOf(biomeString);
                        if (paletteId == -1) {
                            paletteId = biomePalette.size();
                            biomePalette.add(biomeString);
                        }
                        biomeData[x + z * 4 + y * 4 * 4] = paletteId;
                    }
                }
            }
            sections[i] = new PolarSection(blockPaletteStrings.toArray(new String[0]), blockData, biomePalette.toArray(new String[0]), biomeData, PolarSection.LightContent.MISSING, null, PolarSection.LightContent.MISSING, null);
        }
        RegistryAccess.Frozen registryAccess = ((CraftServer)Bukkit.getServer()).getServer().registryAccess();
        for (Map.Entry<BlockPos, BlockEntity> entry : blockEntities) {
            BlockPos blockPos = entry.getKey();
            BlockEntity blockEntity = entry.getValue();
            if (blockPos == null || blockEntity == null) continue;
            CompoundTag compoundTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)registryAccess);
            Optional id = compoundTag.getString("id");
            if (id.isEmpty()) {
                PolarPaper.logger().warning("No ID in block entity data at: " + String.valueOf(blockPos));
                PolarPaper.logger().warning("Compound tag: " + String.valueOf(compoundTag));
                continue;
            }
            int index = CoordConversion.chunkBlockIndex(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            polarBlockEntities.add(new PolarChunk.BlockEntity(index, (String)id.get(), compoundTag));
        }
        int[][] heightMaps = new int[32][0];
        worldAccess.saveHeightmaps(snapshot, heightMaps);
        ByteArrayDataOutput userDataOutput = ByteStreams.newDataOutput();
        worldAccess.saveChunkData(snapshot, blockEntities, entities, userDataOutput);
        byte[] userData = userDataOutput.toByteArray();
        return new PolarChunk(newChunkX, newChunkZ, sections, polarBlockEntities, heightMaps, userData);
    }
}

