/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import live.minehub.polarpaper.PolarPaper;
import net.minecraft.world.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Config(@NotNull String source, int autoSaveIntervalTicks, boolean saveOnStop, boolean loadOnStartup, @NotNull Location spawn, @NotNull Difficulty difficulty, boolean allowMonsters, boolean allowAnimals, boolean allowWorldExpansion, @NotNull WorldType worldType, @NotNull World.Environment environment, @NotNull List<GameRule> gamerules) {
    private static final Logger LOGGER = Logger.getLogger(Config.class.getName());
    public static final Config DEFAULT = new Config("file", -1, false, true, new Location(null, 0.0, 64.0, 0.0), Difficulty.NORMAL, true, true, true, WorldType.NORMAL, World.Environment.NORMAL, List.of(new GameRule("doMobSpawning", false), new GameRule("doFireTick", false), new GameRule("randomTickSpeed", 0), new GameRule("mobGriefing", false), new GameRule("doVinesSpread", false), new GameRule("pvp", true)));

    @NotNull
    public String spawnString() {
        return Config.locationToString(this.spawn());
    }

    @NotNull
    public Config withSpawnPos(Location location) {
        return new Config(this.source, this.autoSaveIntervalTicks, this.saveOnStop, this.loadOnStartup, location, this.difficulty, this.allowMonsters, this.allowAnimals, this.allowWorldExpansion, this.worldType, this.environment, this.gamerules);
    }

    @Nullable
    public static Config readFromConfig(FileConfiguration config, String worldName) {
        String prefix = String.format("worlds.%s.", worldName);
        try {
            String source = config.getString(prefix + "source", Config.DEFAULT.source);
            int autoSaveIntervalTicks = config.getInt(prefix + "autosaveIntervalTicks", Config.DEFAULT.autoSaveIntervalTicks);
            boolean saveOnStop = config.getBoolean(prefix + "saveOnStop", Config.DEFAULT.saveOnStop);
            boolean loadOnStartup = config.getBoolean(prefix + "loadOnStartup", Config.DEFAULT.loadOnStartup);
            String spawn = config.getString(prefix + "spawn", Config.locationToString(Config.DEFAULT.spawn));
            Difficulty difficulty = Difficulty.valueOf((String)config.getString(prefix + "difficulty", Config.DEFAULT.difficulty.name()));
            boolean allowMonsters = config.getBoolean(prefix + "allowMonsters", Config.DEFAULT.allowMonsters);
            boolean allowAnimals = config.getBoolean(prefix + "allowAnimals", Config.DEFAULT.allowAnimals);
            boolean allowWorldExpansion = config.getBoolean(prefix + "allowWorldExpansion", Config.DEFAULT.allowWorldExpansion);
            WorldType worldType = WorldType.valueOf((String)config.getString(prefix + "worldType", Config.DEFAULT.worldType.name()));
            World.Environment environment = World.Environment.valueOf((String)config.getString(prefix + "environment", Config.DEFAULT.environment.name()));
            List gamerules = config.getMapList(prefix + "gamerules");
            ArrayList<GameRule> gamerulesList = new ArrayList<GameRule>();
            for (Map gamerule : gamerules) {
                for (Map.Entry entry : gamerule.entrySet()) {
                    gamerulesList.add(new GameRule((String)entry.getKey(), entry.getValue()));
                }
            }
            if (gamerules.isEmpty()) {
                gamerulesList.addAll(Config.DEFAULT.gamerules);
            }
            return new Config(source, autoSaveIntervalTicks, saveOnStop, loadOnStartup, Config.stringToLocation(spawn), difficulty, allowMonsters, allowAnimals, allowWorldExpansion, worldType, environment, gamerulesList);
        }
        catch (IllegalArgumentException e) {
            PolarPaper.logger().warning("Failed to read config");
            LOGGER.log(Level.INFO, e.getMessage(), e);
            return null;
        }
    }

    public static void writeToConfig(FileConfiguration fileConfig, String worldName, Config config) {
        String prefix = String.format("worlds.%s.", worldName);
        fileConfig.set(prefix + "source", (Object)config.source);
        fileConfig.set(prefix + "autosaveIntervalTicks", (Object)config.autoSaveIntervalTicks);
        fileConfig.setInlineComments(prefix + "autosaveIntervalTicks", List.of("-1 to disable"));
        fileConfig.set(prefix + "saveOnStop", (Object)config.saveOnStop);
        fileConfig.set(prefix + "loadOnStartup", (Object)config.loadOnStartup);
        fileConfig.set(prefix + "spawn", (Object)Config.locationToString(config.spawn));
        fileConfig.set(prefix + "difficulty", (Object)config.difficulty.name());
        fileConfig.set(prefix + "allowMonsters", (Object)config.allowMonsters);
        fileConfig.set(prefix + "allowAnimals", (Object)config.allowAnimals);
        fileConfig.set(prefix + "allowWorldExpansion", (Object)config.allowWorldExpansion);
        fileConfig.setInlineComments(prefix + "allowWorldExpansion", List.of("Whether the world can grow and load more chunks"));
        fileConfig.set(prefix + "worldType", (Object)config.worldType.name());
        fileConfig.setInlineComments(prefix + "worldType", List.of("One of: NORMAL, FLAT, AMPLIFIED, LARGE_BIOMES"));
        fileConfig.set(prefix + "environment", (Object)config.environment.name());
        fileConfig.setInlineComments(prefix + "environment", List.of("One of: NORMAL, NETHER, THE_END, CUSTOM"));
        fileConfig.set(prefix + "gamerules", config.gamerulesMap());
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path configFile = pluginFolder.resolve("config.yml");
        try {
            fileConfig.save(configFile.toFile());
        }
        catch (IOException e) {
            PolarPaper.logger().warning("Failed to save world to config file");
            PolarPaper.logger().warning(e.toString());
        }
    }

    private static String locationToString(Location spawn) {
        return String.format("%s, %s, %s, %s, %s", spawn.x(), spawn.y(), spawn.z(), Float.valueOf(spawn.getYaw()), Float.valueOf(spawn.getPitch()));
    }

    private static Location stringToLocation(String string) {
        String[] split = string.split(",");
        try {
            if (split.length == 3) {
                String x = split[0];
                String y = split[1];
                String z = split[2];
                return new Location(null, Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z));
            }
            if (split.length == 5) {
                String x = split[0];
                String y = split[1];
                String z = split[2];
                String yaw = split[3];
                String pitch = split[4];
                return new Location(null, Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z), Float.parseFloat(yaw), Float.parseFloat(pitch));
            }
            PolarPaper.logger().warning("Failed to parse spawn pos: " + string);
            return Config.DEFAULT.spawn;
        }
        catch (Exception e) {
            PolarPaper.logger().warning("Failed to parse spawn pos: " + string);
            return Config.DEFAULT.spawn;
        }
    }

    @NotNull
    public List<Map<String, ?>> gamerulesMap() {
        ArrayList gamerules = new ArrayList();
        for (GameRule gamerule : this.gamerules()) {
            gamerules.add(gamerule.map());
        }
        return gamerules;
    }

    public record GameRule(String name, Object value) {
        public Map<String, ?> map() {
            return Map.of(this.name, this.value);
        }
    }
}

