/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.util;

import java.util.List;
import net.minecraft.world.level.chunk.Configuration;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.SingleValuePalette;

public final class PaletteUtil {
    private static final Palette.Factory SINGLE_VALUE_PALETTE_FACTORY = SingleValuePalette::create;
    private static final Palette.Factory LINEAR_PALETTE_FACTORY = LinearPalette::create;
    private static final Palette.Factory HASHMAP_PALETTE_FACTORY = HashMapPalette::create;
    static final Configuration ZERO_BITS = new Configuration.Simple(SINGLE_VALUE_PALETTE_FACTORY, 0);
    static final Configuration FOUR_BITS_LINEAR = new Configuration.Simple(LINEAR_PALETTE_FACTORY, 4);
    static final Configuration FIVE_BITS_HASHMAP = new Configuration.Simple(HASHMAP_PALETTE_FACTORY, 5);
    static final Configuration SIX_BITS_HASHMAP = new Configuration.Simple(HASHMAP_PALETTE_FACTORY, 6);
    static final Configuration SEVEN_BITS_HASHMAP = new Configuration.Simple(HASHMAP_PALETTE_FACTORY, 7);
    static final Configuration EIGHT_BITS_HASHMAP = new Configuration.Simple(HASHMAP_PALETTE_FACTORY, 8);

    private PaletteUtil() {
    }

    public static Configuration getConfigurationForBitCount(int bits) {
        return switch (bits) {
            case 0 -> ZERO_BITS;
            case 1, 2, 3, 4 -> FOUR_BITS_LINEAR;
            case 5 -> FIVE_BITS_HASHMAP;
            case 6 -> SIX_BITS_HASHMAP;
            case 7 -> SEVEN_BITS_HASHMAP;
            case 8 -> EIGHT_BITS_HASHMAP;
            default -> new Configuration.Simple(HASHMAP_PALETTE_FACTORY, bits);
        };
    }

    public static <T> Palette<T> createPalette(int bits, List<T> values) {
        return switch (bits) {
            case 0 -> SINGLE_VALUE_PALETTE_FACTORY.create(bits, values);
            case 1, 2, 3, 4 -> LINEAR_PALETTE_FACTORY.create(bits, values);
            default -> HASHMAP_PALETTE_FACTORY.create(bits, values);
        };
    }

    public static int bitsToRepresent(int n) {
        assert (n > 0);
        return 32 - Integer.numberOfLeadingZeros(n);
    }

    public static long[] pack(int[] ints, int bitsPerEntry) {
        int intsPerLong = (int)Math.floor(64.0 / (double)bitsPerEntry);
        long[] longs = new long[(int)Math.ceil((double)ints.length / (double)intsPerLong)];
        long mask = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < longs.length; ++i) {
            for (int intIndex = 0; intIndex < intsPerLong; ++intIndex) {
                int bitIndex = intIndex * bitsPerEntry;
                int intActualIndex = intIndex + i * intsPerLong;
                if (intActualIndex >= ints.length) continue;
                int n = i;
                longs[n] = longs[n] | ((long)ints[intActualIndex] & mask) << bitIndex;
            }
        }
        return longs;
    }

    public static void unpack(int[] out, long[] in, int bitsPerEntry) {
        assert (in.length != 0) : "unpack input array is zero";
        double intsPerLong = Math.floor(64.0 / (double)bitsPerEntry);
        int intsPerLongCeil = (int)Math.ceil(intsPerLong);
        long mask = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < out.length; ++i) {
            int longIndex = i / intsPerLongCeil;
            int subIndex = i % intsPerLongCeil;
            out[i] = (int)(in[longIndex] >>> bitsPerEntry * subIndex & mask);
        }
    }
}

