/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.commands.ConvertCommand;
import live.minehub.polarpaper.commands.CopyCommand;
import live.minehub.polarpaper.commands.CreateBlankCommand;
import live.minehub.polarpaper.commands.CreateFromRegionCommand;
import live.minehub.polarpaper.commands.CropCommand;
import live.minehub.polarpaper.commands.GotoCommand;
import live.minehub.polarpaper.commands.HelpCommand;
import live.minehub.polarpaper.commands.InfoCommand;
import live.minehub.polarpaper.commands.ListCommand;
import live.minehub.polarpaper.commands.LoadCommand;
import live.minehub.polarpaper.commands.PasteCommand;
import live.minehub.polarpaper.commands.ReloadConfigCommand;
import live.minehub.polarpaper.commands.SaveCommand;
import live.minehub.polarpaper.commands.SetSpawnCommand;
import live.minehub.polarpaper.commands.UnloadCommand;
import live.minehub.polarpaper.commands.WandCommand;
import live.minehub.polarpaper.schematic.Rotation;
import live.minehub.polarpaper.schematic.Schematic;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class PolarCommand {
    public static void register(Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"polar").requires(source -> source.getSender().hasPermission("polarpaper.version"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Polar for Paper v", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)PolarPaper.getPlugin().getPluginMeta().getVersion(), (TextColor)NamedTextColor.AQUA)));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"help").requires(source -> source.getSender().hasPermission("polarpaper.help"))).executes(HelpCommand::run))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"goto").requires(source -> source.getSender().hasPermission("polarpaper.goto"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar goto <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                if (world == null) continue;
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(GotoCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"createblank").requires(source -> source.getSender().hasPermission("polarpaper.createblank"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar createblank <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).executes(CreateBlankCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"save").requires(source -> source.getSender().hasPermission("polarpaper.save"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar save <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                PolarWorld polarWorld = PolarWorld.fromWorld(world);
                if (polarWorld == null) continue;
                if (world.getName().contains(" ")) {
                    builder.suggest("\"" + world.getName() + "\"");
                    continue;
                }
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(SaveCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"load").requires(source -> source.getSender().hasPermission("polarpaper.load"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar load <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).executes(LoadCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unload").requires(source -> source.getSender().hasPermission("polarpaper.unload"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Usage: /polar unload <worldname> [save]", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"Setting save will override config", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                PolarWorld polarWorld = PolarWorld.fromWorld(world);
                if (polarWorld == null) continue;
                if (world.getName().contains(" ")) {
                    builder.suggest("\"" + world.getName() + "\"");
                    continue;
                }
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(UnloadCommand::run)).then(Commands.argument((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(UnloadCommand::runOverrided))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").requires(source -> source.getSender().hasPermission("polarpaper.info"))).executes(InfoCommand::run)).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                PolarWorld polarWorld = PolarWorld.fromWorld(world);
                if (polarWorld == null) continue;
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(InfoCommand::runArg)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setspawn").requires(source -> source.getSender().hasPermission("polarpaper.setspawn"))).executes(ctx -> SetSpawnCommand.run((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.literal((String)"rounded").executes(ctx -> SetSpawnCommand.run((CommandContext<CommandSourceStack>)ctx, true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reloadconfig").requires(source -> source.getSender().hasPermission("polarpaper.reloadconfig"))).executes(ReloadConfigCommand::run))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> source.getSender().hasPermission("polarpaper.list"))).executes(ListCommand::run))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"convert").requires(source -> source.getSender().hasPermission("polarpaper.convert"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar convert <new worldname> <chunk radius> (While in a non-polar world) to convert the chunks around you", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"newworldname", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"chunkradius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ConvertCommand::run))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"paste").requires(source -> source.getSender().hasPermission("polarpaper.paste"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar paste <worldname> [rotation] [air ignore] (While in a world) to place a polar world at your current position", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.string()).executes(PasteCommand::run)).then(((RequiredArgumentBuilder)Commands.argument((String)"rotation", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (Rotation rotation : Rotation.values()) {
                builder.suggest(rotation.getFriendlyName());
            }
            return builder.buildFuture();
        }).executes(PasteCommand::runWithRotation)).then(Commands.argument((String)"ignoreair", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (Schematic.IgnoreAir ignoreAir : Schematic.IgnoreAir.values()) {
                builder.suggest(ignoreAir.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(PasteCommand::runWithRotationAndAirIgnore)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"wand").requires(source -> source.getSender().hasPermission("polarpaper.wand"))).executes(WandCommand::wand))).then(((LiteralArgumentBuilder)Commands.literal((String)"pos1").requires(source -> source.getSender().hasPermission("polarpaper.wand"))).executes(WandCommand::pos1))).then(((LiteralArgumentBuilder)Commands.literal((String)"pos2").requires(source -> source.getSender().hasPermission("polarpaper.wand"))).executes(WandCommand::pos2))).then(((LiteralArgumentBuilder)Commands.literal((String)"crop").requires(source -> source.getSender().hasPermission("polarpaper.crop"))).executes(CropCommand::run))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"createfromregion").requires(source -> source.getSender().hasPermission("polarpaper.convert"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar createfromregion <new worldname> (While in a world) to create a new polar world from the selected region", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"newworldname", (ArgumentType)StringArgumentType.string()).executes(CreateFromRegionCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"copy").requires(source -> source.getSender().hasPermission("polarpaper.copy"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar copy <worldname> <new worldname> to copy a polar world", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"newworldname", (ArgumentType)StringArgumentType.string()).executes(CopyCommand::run))))).build());
    }
}

