/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWriter;
import live.minehub.polarpaper.schematic.Schematic;
import live.minehub.polarpaper.source.FilePolarSource;
import live.minehub.polarpaper.userdata.WorldUserData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.joml.Vector3i;

public class CropCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar crop (while in a polar world)", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Player player = (Player)commandSender;
        World bukkitWorld = player.getWorld();
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (polarWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is not a polar world!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        PolarGenerator polarGenerator = PolarGenerator.fromWorld(bukkitWorld);
        if (polarGenerator == null) {
            return 1;
        }
        PersistentDataContainer data = player.getPersistentDataContainer();
        int[] pos1Array = (int[])data.get(Schematic.POS_1_KEY, PersistentDataType.INTEGER_ARRAY);
        int[] pos2Array = (int[])data.get(Schematic.POS_2_KEY, PersistentDataType.INTEGER_ARRAY);
        if (pos1Array == null || pos2Array == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"You need to select two corners with the polar wand!", (TextColor)NamedTextColor.RED));
            return 1;
        }
        Vector3i pos1 = new Vector3i(pos1Array);
        Vector3i pos2 = new Vector3i(pos2Array);
        BlockSelector.RegionBlockSelector blockSelector = BlockSelector.RegionBlockSelector.fromCorners(pos1, pos2);
        Vector3i schemOffset = player.getLocation().toVector().toVector3i();
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Cropping '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.GRAY)));
        long before = System.nanoTime();
        Polar.updateConfig(bukkitWorld, bukkitWorld.getName());
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
            polarWorld.updateChunks(bukkitWorld, polarGenerator.getWorldAccess(), blockSelector);
            polarWorld.userData(WorldUserData.writeSchematicOffset(schemOffset));
            byte[] worldBytes = PolarWriter.write(polarWorld);
            FilePolarSource.defaultFolder(bukkitWorld.getName()).saveBytes(worldBytes);
            int ms = (int)((System.nanoTime() - before) / 1000000L);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Cropped '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms", (TextColor)NamedTextColor.AQUA)));
        });
        return 1;
    }
}

