/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.util.CoordConversion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public record PolarChunk(int x, int z, PolarSection[] sections, List<BlockEntity> blockEntities, int[][] heightmaps, byte[] userData) {
    public static final int HEIGHTMAP_NONE = 0;
    public static final int HEIGHTMAP_MOTION_BLOCKING = 1;
    public static final int HEIGHTMAP_MOTION_BLOCKING_NO_LEAVES = 2;
    public static final int HEIGHTMAP_OCEAN_FLOOR = 4;
    public static final int HEIGHTMAP_OCEAN_FLOOR_WG = 8;
    public static final int HEIGHTMAP_WORLD_SURFACE = 16;
    public static final int HEIGHTMAP_WORLD_SURFACE_WG = 32;
    static final int[] HEIGHTMAPS = new int[]{0, 1, 2, 4, 8, 16, 32};
    static final int HEIGHTMAP_SIZE = 256;
    static final int MAX_HEIGHTMAPS = 32;

    public PolarChunk(int x, int z, int sectionCount) {
        this(x, z, new PolarSection[sectionCount], List.of(), new int[32][0], new byte[0]);
        Arrays.setAll(this.sections, i -> new PolarSection());
    }

    public int @Nullable [] heightmap(int type) {
        return this.heightmaps[type];
    }

    public boolean isEmpty() {
        for (PolarSection section : this.sections) {
            if (section.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public PolarChunk withUserData(byte[] newUserData) {
        return new PolarChunk(this.x, this.z, this.sections, this.blockEntities, this.heightmaps, newUserData);
    }

    public static PolarChunk convert(World world, int chunkX, int chunkZ, PolarWorldAccess worldAccess, BlockSelector blockSelector) {
        ServerLevel chunkSystemServerLevel = ((CraftWorld)world).getHandle();
        ChunkHolderManager chunkHolderManager = chunkSystemServerLevel.moonrise$getChunkTaskScheduler().chunkHolderManager;
        return PolarChunk.convert(chunkHolderManager.getChunkHolder(chunkX, chunkZ), worldAccess, blockSelector);
    }

    public static PolarChunk convert(NewChunkHolder chunkHolder, PolarWorldAccess worldAccess, BlockSelector blockSelector) {
        ChunkAccess chunkAccess = chunkHolder.getCurrentChunk();
        ChunkEntitySlices entityChunk = chunkHolder.getEntityChunk();
        int chunkX = chunkHolder.chunkX;
        int chunkZ = chunkHolder.chunkZ;
        ArrayList<BlockEntity> polarBlockEntities = new ArrayList<BlockEntity>();
        Registry biomeRegistry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME);
        int sectionCount = chunkAccess.getSectionsCount();
        int minSection = chunkAccess.getMinSectionY();
        PolarSection[] sections = new PolarSection[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            Object[] biomePalette;
            LevelChunkSection chunkAccessSection = chunkAccess.getSection(i);
            Object blockData = null;
            ArrayList<String> blockPaletteStrings = new ArrayList<String>();
            ArrayList<String> biomePaletteStrings = new ArrayList<String>();
            if (!chunkAccessSection.hasOnlyAir()) {
                Object[] palette;
                PalettedContainer.Data blockPaletteData = chunkAccessSection.getStates().data;
                for (Object p : palette = blockPaletteData.palette().moonrise$getRawPalette((FastPaletteData)blockPaletteData)) {
                    if (p == null || !(p instanceof BlockState)) continue;
                    BlockState blockState = (BlockState)p;
                    blockPaletteStrings.add(blockState.toString().replace("Block{", "").replace("}", ""));
                }
                int airIndex = blockPaletteStrings.indexOf("minecraft:air");
                if (airIndex == -1) {
                    blockPaletteStrings.add("minecraft:air");
                    airIndex = blockPaletteStrings.size() - 1;
                }
                BitStorage blockBitStorage = blockPaletteData.storage();
                int blockPaletteSize = blockBitStorage.getSize();
                blockData = new int[blockPaletteSize];
                for (int index = 0; index < blockPaletteSize; ++index) {
                    boolean included = blockSelector.test(index, chunkX, chunkZ, minSection + i);
                    if (included) {
                        int paletteIdx = blockBitStorage.get(index);
                        blockData[index] = paletteIdx;
                        continue;
                    }
                    blockData[index] = airIndex;
                }
            } else {
                blockPaletteStrings.add(Blocks.AIR.defaultBlockState().toString().replace("Block{", "").replace("}", ""));
            }
            PalettedContainer.Data biomePaletteData = ((PalettedContainer)chunkAccessSection.getBiomes()).data;
            for (Object p : biomePalette = biomePaletteData.palette().moonrise$getRawPalette((FastPaletteData)biomePaletteData)) {
                Biome biome;
                ResourceLocation key;
                Holder biomeHolder;
                Object object;
                if (p == null || !(p instanceof Holder) || !((object = (biomeHolder = (Holder)p).value()) instanceof Biome) || (key = biomeRegistry.getKey((Object)(biome = (Biome)object))) == null) continue;
                String biomeString = key.getPath();
                biomePaletteStrings.add(biomeString);
            }
            BitStorage biomeBitStorage = biomePaletteData.storage();
            int biomePaletteSize = biomeBitStorage.getSize();
            int[] nArray = new int[biomePaletteSize];
            for (int index = 0; index < biomePaletteSize; ++index) {
                int paletteIdx;
                nArray[index] = paletteIdx = biomeBitStorage.get(index);
            }
            sections[i] = new PolarSection(blockPaletteStrings.toArray(new String[0]), (int[])blockData, biomePaletteStrings.toArray(new String[0]), nArray, PolarSection.LightContent.MISSING, null, PolarSection.LightContent.MISSING, null);
        }
        RegistryAccess.Frozen registryAccess = ((CraftServer)Bukkit.getServer()).getServer().registryAccess();
        Set<Map.Entry<BlockPos, net.minecraft.world.level.block.entity.BlockEntity>> blockEntities = chunkAccess.blockEntities.entrySet();
        for (Map.Entry entry : blockEntities) {
            BlockPos blockPos = (BlockPos)entry.getKey();
            net.minecraft.world.level.block.entity.BlockEntity blockEntity = (net.minecraft.world.level.block.entity.BlockEntity)entry.getValue();
            if (blockPos == null || blockEntity == null || !blockSelector.test(blockPos.getX(), blockPos.getY(), blockPos.getZ())) continue;
            CompoundTag compoundTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)registryAccess);
            Optional id = compoundTag.getString("id");
            if (id.isEmpty()) {
                PolarPaper.logger().warning("No ID in block entity data at: " + String.valueOf(blockPos));
                PolarPaper.logger().warning("Compound tag: " + String.valueOf(compoundTag));
                continue;
            }
            int index = CoordConversion.chunkBlockIndex(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            polarBlockEntities.add(new BlockEntity(index, (String)id.get(), compoundTag));
        }
        int[][] heightMaps = new int[32][0];
        worldAccess.saveHeightmaps(chunkAccess, heightMaps);
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        List allEntities = entityChunk == null ? List.of() : entityChunk.getAllEntities();
        ArrayList<CraftEntity> newAllEntities = new ArrayList<CraftEntity>();
        for (net.minecraft.world.entity.Entity ent : allEntities) {
            if (!blockSelector.test(ent.getBlockX(), ent.getBlockY(), ent.getBlockZ())) continue;
            newAllEntities.add(ent.getBukkitEntity());
        }
        Entity[] entitiesArray = newAllEntities.toArray(new Entity[0]);
        worldAccess.saveChunkData(chunkAccess, blockEntities, entitiesArray, byteArrayDataOutput);
        byte[] userData = byteArrayDataOutput.toByteArray();
        return new PolarChunk(chunkX, chunkZ, sections, polarBlockEntities, heightMaps, userData);
    }

    public record BlockEntity(int index, @Nullable String id, @Nullable CompoundTag data) {
    }
}

