/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import live.minehub.polarpaper.util.CoordConversion;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public interface BlockSelector {
    @NotNull
    public static final BlockSelector ALL = new BlockSelector(){

        @Override
        public boolean test(int x, int y, int z) {
            return true;
        }

        @Override
        public boolean test(int index, int chunkX, int chunkZ, int sectionY) {
            return true;
        }
    };

    @NotNull
    public static BlockSelector circle(int radius) {
        return BlockSelector.circle(0, 0, radius);
    }

    @NotNull
    public static BlockSelector circle(final int centerX, final int centerZ, final int radius) {
        return new BlockSelector(){

            @Override
            public boolean test(int x, int y, int z) {
                return true;
            }

            @Override
            public boolean test(int index, int chunkX, int chunkZ, int sectionY) {
                return true;
            }

            @Override
            public boolean testChunk(int x, int z) {
                int dx = x - centerX;
                int dz = z - centerZ;
                return dx * dx + dz * dz <= radius * radius;
            }
        };
    }

    @NotNull
    public static BlockSelector square(int radius) {
        return BlockSelector.square(0, 0, radius);
    }

    @NotNull
    public static BlockSelector square(final int centerX, final int centerZ, final int radius) {
        return new BlockSelector(){

            @Override
            public boolean test(int x, int y, int z) {
                return true;
            }

            @Override
            public boolean test(int index, int chunkX, int chunkZ, int sectionY) {
                return true;
            }

            @Override
            public boolean testChunk(int x, int z) {
                long dz;
                long dx = Math.abs(x - centerX);
                return Math.max(dx, dz = (long)Math.abs(z - centerZ)) <= (long)radius;
            }
        };
    }

    public boolean test(int var1, int var2, int var3);

    default public boolean test(int index, int chunkX, int chunkZ, int sectionY) {
        return this.test(CoordConversion.sectionBlockIndexGetX(index) + chunkX * 16, CoordConversion.sectionBlockIndexGetY(index) + sectionY * 16, CoordConversion.sectionBlockIndexGetZ(index) + chunkZ * 16);
    }

    default public boolean testChunk(int chunkX, int chunkZ) {
        return true;
    }

    public record RegionBlockSelector(Vector3i min, Vector3i max) implements BlockSelector
    {
        public static RegionBlockSelector fromCorners(Vector3i corner1, Vector3i corner2) {
            return new RegionBlockSelector(corner1.min((Vector3ic)corner2, new Vector3i()), corner1.max((Vector3ic)corner2, new Vector3i()));
        }

        @Override
        public boolean test(int x, int y, int z) {
            return this.min.x <= x && this.max.x >= x && this.min.y <= y && this.max.y >= y && this.min.z <= z && this.max.z >= z;
        }

        @Override
        public boolean testChunk(int chunkX, int chunkZ) {
            int minX = chunkX * 16;
            int maxX = minX + 16;
            int minZ = chunkZ * 16;
            int maxZ = minZ + 16;
            return this.min.x <= maxX && this.max.x >= minX && this.min.z <= maxZ && this.max.z >= minZ;
        }
    }
}

