/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.util;

import com.google.common.io.ByteArrayDataOutput;
import io.netty.buffer.ByteBuf;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import live.minehub.polarpaper.PolarChunk;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteArrayUtil {
    public static byte[] getByteArray(ByteBuffer bb) {
        int packedLength = ByteArrayUtil.getVarInt(bb);
        byte[] bytes = new byte[packedLength];
        for (int i = 0; i < packedLength; ++i) {
            bytes[i] = bb.get();
        }
        return bytes;
    }

    public static byte[] getByteArray(ByteBuf bb) {
        int packedLength = ByteArrayUtil.getVarInt(bb);
        byte[] bytes = new byte[packedLength];
        for (int i = 0; i < packedLength; ++i) {
            bytes[i] = bb.readByte();
        }
        return bytes;
    }

    public static long[] getLongArray(ByteBuf bb) {
        int packedLength = ByteArrayUtil.getVarInt(bb);
        long[] longs = new long[packedLength];
        for (int i = 0; i < packedLength; ++i) {
            longs[i] = bb.readLong();
        }
        return longs;
    }

    public static int getVarInt(ByteBuffer bb) {
        byte tmp = bb.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = bb.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = bb.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = bb.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = bb.get();
                    result |= tmp << 28;
                    while (tmp < 0) {
                        tmp = bb.get();
                    }
                }
            }
        }
        return result;
    }

    public static int getVarInt(ByteBuf bb) {
        byte tmp = bb.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = bb.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = bb.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = bb.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = bb.readByte();
                    result |= tmp << 28;
                    while (tmp < 0) {
                        tmp = bb.readByte();
                    }
                }
            }
        }
        return result;
    }

    @NotNull
    public static String getString(ByteBuf bb) {
        int length = ByteArrayUtil.getVarInt(bb);
        byte[] bytes = new byte[length];
        bb.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Nullable
    public static String getStringOptional(ByteBuf bb) {
        boolean present;
        boolean bl = present = bb.readByte() == 1;
        if (!present) {
            return null;
        }
        return ByteArrayUtil.getString(bb);
    }

    public static String[] getStringList(ByteBuf bb, int maxSize) {
        int length = ByteArrayUtil.getVarInt(bb);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = ByteArrayUtil.getString(bb);
        }
        return strings;
    }

    public static byte[] getLightData(ByteBuf bb) {
        byte[] bytes = new byte[2048];
        bb.readBytes(bytes);
        return bytes;
    }

    public static void writeBlockEntity(@NotNull ByteArrayDataOutput bb, @NotNull PolarChunk.BlockEntity blockEntity) {
        bb.writeInt(blockEntity.index());
        bb.write(blockEntity.id() == null ? 0 : 1);
        if (blockEntity.id() != null) {
            ByteArrayUtil.writeString(blockEntity.id(), bb);
        }
        bb.write(blockEntity.data() == null ? 0 : 1);
        if (blockEntity.data() != null) {
            try {
                NbtIo.writeAnyTag((Tag)blockEntity.data(), (DataOutput)bb);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void writeVarInt(int v, ByteArrayDataOutput bb) {
        while (true) {
            int bits = v & 0x7F;
            if ((v >>>= 7) == 0) {
                bb.write((int)((byte)bits));
                return;
            }
            bb.write((int)((byte)(bits | 0x80)));
        }
    }

    public static void writeString(String s, ByteArrayDataOutput bb) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        ByteArrayUtil.writeVarInt(bytes.length, bb);
        bb.write(bytes);
    }

    public static void writeByteArray(byte[] bytes, ByteArrayDataOutput bb) {
        ByteArrayUtil.writeVarInt(bytes.length, bb);
        bb.write(bytes);
    }

    public static void writeLongArray(long[] longs, ByteArrayDataOutput bb) {
        ByteArrayUtil.writeVarInt(longs.length, bb);
        for (long aLong : longs) {
            bb.writeLong(aLong);
        }
    }

    public static void writeStringArray(String[] strings, ByteArrayDataOutput bb) {
        ByteArrayUtil.writeVarInt(strings.length, bb);
        for (String aString : strings) {
            ByteArrayUtil.writeString(aString, bb);
        }
    }
}

