/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Map;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.World;

public class ReloadConfigCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        PolarPaper.getPlugin().reloadConfig();
        int numWorlds = 0;
        for (World bukkitWorld : Bukkit.getWorlds()) {
            PolarGenerator generator;
            PolarWorld world;
            if (!Polar.isInConfig(bukkitWorld.getName()) || (world = PolarWorld.fromWorld(bukkitWorld)) == null || (generator = PolarGenerator.fromWorld(bukkitWorld)) == null) continue;
            Config config = Config.readFromConfig(PolarPaper.getPlugin().getConfig(), bukkitWorld.getName());
            generator.setConfig(config);
            bukkitWorld.setDifficulty(Difficulty.valueOf((String)config.difficulty().name()));
            bukkitWorld.setSpawnFlags(config.allowMonsters(), config.allowAnimals());
            bukkitWorld.setAutoSave(false);
            for (Map.Entry<String, Object> gamerule : config.gamerules().entrySet()) {
                GameRule rule = GameRule.getByName((String)gamerule.getKey());
                if (rule == null) continue;
                Polar.setGameRule(bukkitWorld, rule, gamerule.getValue());
            }
            Polar.startAutoSaveTask(bukkitWorld, config);
            ++numWorlds;
        }
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Reloaded config for ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)numWorlds, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" worlds", (TextColor)NamedTextColor.AQUA)));
        return 1;
    }
}

