/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.commands.ConvertCommand;
import live.minehub.polarpaper.commands.CreateBlankCommand;
import live.minehub.polarpaper.commands.GotoCommand;
import live.minehub.polarpaper.commands.HelpCommand;
import live.minehub.polarpaper.commands.InfoCommand;
import live.minehub.polarpaper.commands.ListCommand;
import live.minehub.polarpaper.commands.LoadCommand;
import live.minehub.polarpaper.commands.ReloadConfigCommand;
import live.minehub.polarpaper.commands.SaveCommand;
import live.minehub.polarpaper.commands.SetSpawnCommand;
import live.minehub.polarpaper.commands.UnloadCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class PolarCommand {
    public static void register(Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"polar").requires(source -> source.getSender().hasPermission("paperpolar.version"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Polar for Paper v", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)PolarPaper.getPlugin().getPluginMeta().getVersion(), (TextColor)NamedTextColor.AQUA)));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"help").requires(source -> source.getSender().hasPermission("paperpolar.help"))).executes(HelpCommand::run))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"goto").requires(source -> source.getSender().hasPermission("paperpolar.goto"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar goto <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                if (world == null) continue;
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(GotoCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"createblank").requires(source -> source.getSender().hasPermission("paperpolar.createblank"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar createblank <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).executes(CreateBlankCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"save").requires(source -> source.getSender().hasPermission("paperpolar.save"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Usage: /polar save <worldname> to save all chunks\n", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)" OR /polar save <worldname> [chunk radius] [centered] to save a region", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"\nUse centered to center the saved radius around your player", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                PolarWorld polarWorld = PolarWorld.fromWorld(world);
                if (polarWorld == null) continue;
                if (world.getName().contains(" ")) {
                    builder.suggest("\"" + world.getName() + "\"");
                    continue;
                }
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(SaveCommand::run)).then(((RequiredArgumentBuilder)Commands.argument((String)"chunkradius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SaveCommand::runSelected)).then(Commands.literal((String)"centered").executes(SaveCommand::runSelectedCentered)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"load").requires(source -> source.getSender().hasPermission("paperpolar.load"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar load <worldname>", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).executes(LoadCommand::run)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unload").requires(source -> source.getSender().hasPermission("paperpolar.load"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Usage: /polar load <worldname> [save]", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"Setting save will override config", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                PolarWorld polarWorld = PolarWorld.fromWorld(world);
                if (polarWorld == null) continue;
                if (world.getName().contains(" ")) {
                    builder.suggest("\"" + world.getName() + "\"");
                    continue;
                }
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(UnloadCommand::run)).then(Commands.argument((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(UnloadCommand::runOverrided))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").requires(source -> source.getSender().hasPermission("polarpaper.info"))).executes(InfoCommand::run)).then(Commands.argument((String)"worldname", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            for (World world : Bukkit.getWorlds()) {
                PolarWorld polarWorld = PolarWorld.fromWorld(world);
                if (polarWorld == null) continue;
                builder.suggest(world.getName());
            }
            return builder.buildFuture();
        }).executes(InfoCommand::runArg)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setspawn").requires(source -> source.getSender().hasPermission("polarpaper.info"))).executes(ctx -> SetSpawnCommand.run((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.literal((String)"rounded").executes(ctx -> SetSpawnCommand.run((CommandContext<CommandSourceStack>)ctx, true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reloadconfig").requires(source -> source.getSender().hasPermission("polarpaper.reloadconfig"))).executes(ReloadConfigCommand::run))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> source.getSender().hasPermission("polarpaper.list"))).executes(ListCommand::run))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"convert").requires(source -> source.getSender().hasPermission("polarpaper.convert"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Usage: /polar convert <new worldname> <chunk radius> (While in a non-polar world) to convert the chunks around you", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)" OR: /polar convert <new worldname> <chunk radius> centered (While in a non-polar world) to center the new converted chunks at 0,0", (TextColor)NamedTextColor.RED)));
            return 1;
        })).then(Commands.argument((String)"newworldname", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"chunkradius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ConvertCommand::run)).then(Commands.literal((String)"centered").executes(ConvertCommand::runCentered)))))).build());
    }
}

