/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar info (while in a polar world)", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Player player = (Player)sender;
        return InfoCommand.printInfo(ctx, player.getWorld().getName());
    }

    protected static int runArg(CommandContext<CommandSourceStack> ctx) {
        String worldName = (String)ctx.getArgument("worldname", String.class);
        return InfoCommand.printInfo(ctx, worldName);
    }

    protected static int printInfo(CommandContext<CommandSourceStack> ctx, String worldName) {
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"'", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' does not exist", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (polarWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"'", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is not a polar world", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Config config = Config.readFromConfig(PolarPaper.getPlugin().getConfig(), bukkitWorld.getName());
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Info for ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)":", (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Version: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)polarWorld.version(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" (", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)polarWorld.dataVersion(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Compression: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)polarWorld.compression().name(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Source: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)config.source(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Spawn: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)config.spawnString(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Loaded Chunks: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)polarWorld.chunks().size(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Expand Chunks: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)polarWorld.expandChunks().size(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)" Non-empty Chunks: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)polarWorld.nonEmptyChunks(), (TextColor)NamedTextColor.AQUA)));
        return 1;
    }
}

