/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.nio.file.Path;
import live.minehub.polarpaper.ChunkSelector;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.source.FilePolarSource;
import live.minehub.polarpaper.util.CoordConversion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConvertCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        return ConvertCommand.convert(ctx, false);
    }

    protected static int runCentered(CommandContext<CommandSourceStack> ctx) {
        return ConvertCommand.convert(ctx, true);
    }

    private static int convert(CommandContext<CommandSourceStack> ctx, boolean centered) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        World bukkitWorld = player.getWorld();
        String worldName = bukkitWorld.getName();
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (polarWorld != null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is already converted!", (TextColor)NamedTextColor.RED))).append((Component)Component.newline())).append((Component)Component.text((String)"Just use ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"/polar save "))).append((Component)Component.text((String)worldName)));
            return 1;
        }
        String newWorldName = (String)ctx.getArgument("newworldname", String.class);
        Integer chunkRadius = (Integer)ctx.getArgument("chunkradius", Integer.class);
        World newBukkitWorld = Bukkit.getWorld((String)newWorldName);
        if (newBukkitWorld != null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)newBukkitWorld.getName(), (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' already exists!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Chunk playerChunk = player.getChunk();
        Location spawnLocation = player.getLocation().clone();
        if (centered) {
            spawnLocation.set(0.0, spawnLocation.getY(), 0.0);
        }
        long before = System.nanoTime();
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Converting '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.AQUA)));
        Polar.updateConfig(bukkitWorld, newWorldName);
        int minHeight = bukkitWorld.getMinHeight();
        int maxHeight = bukkitWorld.getMaxHeight() - 1;
        PolarWorld newPolarWorld = new PolarWorld((byte)CoordConversion.sectionIndex(minHeight), (byte)CoordConversion.sectionIndex(maxHeight));
        int offsetX = centered ? 0 : playerChunk.getX();
        int offsetZ = centered ? 0 : playerChunk.getZ();
        for (int x = -chunkRadius.intValue(); x <= chunkRadius; ++x) {
            for (int z = -chunkRadius.intValue(); z <= chunkRadius; ++z) {
                newPolarWorld.addExpandChunk(x + offsetX, z + offsetZ);
            }
        }
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        Path newWorldPath = worldsFolder.resolve(newWorldName + ".polar");
        int offset2X = centered ? playerChunk.getX() : 0;
        int offset2Z = centered ? playerChunk.getZ() : 0;
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> Polar.saveWorld(bukkitWorld, newPolarWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, new FilePolarSource(newWorldPath), ChunkSelector.square(offsetX, offsetZ, chunkRadius), offset2X, offset2Z).thenAccept(successful -> {
            if (successful.booleanValue()) {
                int ms = (int)((System.nanoTime() - before) / 1000000L);
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Done converting '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms. ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"Use ", (TextColor)NamedTextColor.AQUA))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"/polar load ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/polar load " + newWorldName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to run"))))).append((Component)Component.text((String)" to load the world now", (TextColor)NamedTextColor.AQUA)));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Failed to convert '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED)));
                PolarPaper.logger().warning("Error while converting world " + newWorldName);
            }
        }));
        return 1;
    }
}

