/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import com.google.common.io.ByteArrayDataOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Painting;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PolarWorldAccess {
    public static final PolarWorldAccess NOOP = new PolarWorldAccess(){};
    public static final PolarWorldAccess POLAR_PAPER_FEATURES = new PolarWorldAccess(){
        private static final byte CURRENT_FEATURES_VERSION = 1;

        @Override
        public void populateChunkData(@NotNull Chunk chunk, byte @Nullable [] userData) {
            List<PolarChunk.Entity> entities = EntityUtil.getEntities(userData);
            for (PolarChunk.Entity polarEntity : entities) {
                Painting painting;
                Entity entity;
                double x = polarEntity.x();
                double y = polarEntity.y();
                double z = polarEntity.z();
                float yaw = polarEntity.yaw();
                float pitch = polarEntity.pitch();
                byte[] bytes = polarEntity.bytes();
                try {
                    entity = EntityUtil.bytesToEntity(chunk.getWorld(), bytes);
                    if (entity == null) {
                    }
                }
                catch (Exception e) {}
                continue;
                if (entity instanceof Painting && (painting = (Painting)entity).getArt().getBlockHeight() % 2 == 0) {
                    y -= 1.0;
                }
                entity.spawnAt(new Location(chunk.getWorld(), x + (double)(chunk.getX() * 16), y, z + (double)(chunk.getZ() * 16), yaw, pitch));
            }
        }

        @Override
        public void saveChunkData(@NotNull ChunkSnapshot chunk, @NotNull Set<Map.Entry<BlockPos, BlockEntity>> blockEntities, @NotNull Entity[] entities, @NotNull ByteArrayDataOutput userData) {
            ArrayList<PolarChunk.Entity> polarEntities = new ArrayList<PolarChunk.Entity>();
            for (Entity entity : entities) {
                byte[] entityBytes = EntityUtil.entityToBytes(entity);
                if (entityBytes == null) continue;
                Location entityPos = entity.getLocation();
                double x = (entityPos.x() % 16.0 + 16.0) % 16.0;
                double z = (entityPos.z() % 16.0 + 16.0) % 16.0;
                polarEntities.add(new PolarChunk.Entity(x, entityPos.y(), z, entityPos.getYaw(), entityPos.getPitch(), entityBytes));
            }
            userData.writeByte(1);
            EntityUtil.writeEntities(polarEntities, userData);
        }
    };

    default public void loadChunkData(@NotNull ChunkGenerator.ChunkData chunkData, byte @Nullable [] userData) {
    }

    default public void populateChunkData(@NotNull Chunk chunk, byte @Nullable [] userData) {
    }

    default public void saveChunkData(@NotNull ChunkSnapshot chunk, @NotNull Set<Map.Entry<BlockPos, BlockEntity>> blockEntities, @NotNull Entity[] entities, @NotNull ByteArrayDataOutput userData) {
    }

    @ApiStatus.Experimental
    default public void loadHeightmaps(@NotNull ChunkGenerator.ChunkData chunkData, int[][] heightmaps) {
    }

    @ApiStatus.Experimental
    default public void saveHeightmaps(@NotNull ChunkSnapshot chunk, int[][] heightmaps) {
    }
}

