/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.util.CoordConversion;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarWorld {
    public static final int MAGIC_NUMBER = 1349479538;
    public static final short LATEST_VERSION = 7;
    static final short VERSION_UNIFIED_LIGHT = 1;
    static final short VERSION_USERDATA_OPT_BLOCK_ENT_NBT = 2;
    static final short VERSION_MINESTOM_NBT_READ_BREAK = 3;
    static final short VERSION_WORLD_USERDATA = 4;
    static final short VERSION_SHORT_GRASS = 5;
    static final short VERSION_DATA_CONVERTER = 6;
    static final short VERSION_IMPROVED_LIGHT = 7;
    static final short VERSION_DEPRECATED_ENTITIES = 8;
    public static CompressionType DEFAULT_COMPRESSION = CompressionType.ZSTD;
    private final short version;
    private final int dataVersion;
    private CompressionType compression;
    private final byte minSection;
    private final byte maxSection;
    private byte @NotNull [] userData;
    private final Long2ObjectMap<PolarChunk> chunks = new Long2ObjectOpenHashMap();
    private final LongArraySet expandChunks = new LongArraySet();
    private final ReentrantReadWriteLock chunksLock = new ReentrantReadWriteLock();

    public PolarWorld(byte minSection, byte maxSection) {
        this(7, Bukkit.getUnsafe().getDataVersion(), DEFAULT_COMPRESSION, minSection, maxSection, new byte[0], List.of());
    }

    public PolarWorld(short version, int dataVersion, @NotNull CompressionType compression, byte minSection, byte maxSection, byte @NotNull [] userData, @NotNull List<PolarChunk> chunks) {
        this.version = version;
        this.dataVersion = dataVersion;
        this.compression = compression;
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.userData = userData;
        for (PolarChunk chunk : chunks) {
            long index = CoordConversion.chunkIndex(chunk.x(), chunk.z());
            this.chunks.put(index, (Object)chunk);
        }
    }

    public short version() {
        return this.version;
    }

    public int dataVersion() {
        return this.dataVersion;
    }

    @NotNull
    public CompressionType compression() {
        return this.compression;
    }

    public void setCompression(@NotNull CompressionType compression) {
        this.compression = compression;
    }

    public byte minSection() {
        return this.minSection;
    }

    public byte maxSection() {
        return this.maxSection;
    }

    public byte @NotNull [] userData() {
        return this.userData;
    }

    public void userData(byte @NotNull [] userData) {
        this.userData = userData;
    }

    @Nullable
    public PolarChunk chunkAt(int x, int z) {
        this.chunksLock.readLock().lock();
        PolarChunk chunk = (PolarChunk)this.chunks.getOrDefault(CoordConversion.chunkIndex(x, z), null);
        this.chunksLock.readLock().unlock();
        return chunk;
    }

    public void removeChunkAt(int x, int z) {
        this.chunksLock.writeLock().lock();
        this.chunks.remove(CoordConversion.chunkIndex(x, z));
        this.chunksLock.writeLock().unlock();
    }

    public void updateChunkAt(int x, int z, @NotNull PolarChunk chunk) {
        this.chunksLock.writeLock().lock();
        this.chunks.put(CoordConversion.chunkIndex(x, z), (Object)chunk);
        this.chunksLock.writeLock().unlock();
    }

    public void addExpandChunk(int x, int z) {
        this.chunksLock.writeLock().lock();
        this.expandChunks.add(CoordConversion.chunkIndex(x, z));
        this.chunksLock.writeLock().unlock();
    }

    @NotNull
    public Collection<PolarChunk> chunks() {
        return this.chunks.values();
    }

    public LongArraySet expandChunks() {
        return this.expandChunks;
    }

    public int nonEmptyChunks() {
        int count = 0;
        for (PolarChunk chunk : this.chunks()) {
            if (chunk.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public static PolarWorld fromWorld(World world) {
        if (world == null) {
            return null;
        }
        ChunkGenerator generator = world.getGenerator();
        if (!(generator instanceof PolarGenerator)) {
            return null;
        }
        PolarGenerator polarGenerator = (PolarGenerator)generator;
        return polarGenerator.getPolarWorld();
    }

    public static enum CompressionType {
        NONE,
        ZSTD;

        private static final CompressionType[] VALUES;

        @Nullable
        public static CompressionType fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return null;
            }
            return VALUES[id];
        }

        static {
            VALUES = CompressionType.values();
        }
    }
}

