/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import live.minehub.polarpaper.ChunkSelector;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarListener;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.commands.PolarCommand;
import live.minehub.polarpaper.source.FilePolarSource;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class PolarPaper
extends JavaPlugin {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void onEnable() {
        @NotNull LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            @NotNull Commands commands = (Commands)event.registrar();
            PolarCommand.register(commands);
        });
        PolarPaper.registerEvents();
        Path pluginFolder = Path.of(this.getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        worldsFolder.toFile().mkdirs();
        this.saveDefaultConfig();
        try (Stream<Path> files = Files.list(worldsFolder);){
            files.forEach(path -> {
                Config config;
                if (!path.getFileName().toString().endsWith(".polar")) {
                    return;
                }
                String worldName = path.getFileName().toString().split("\\.polar")[0];
                if (!Polar.isInConfig(worldName)) {
                    Config.writeToConfig(this.getConfig(), worldName, Config.DEFAULT);
                }
                if (!(config = Config.readFromConfig(this.getConfig(), worldName)).loadOnStartup()) {
                    return;
                }
                this.getLogger().info("Loading polar world: " + worldName);
                Polar.loadWorldConfigSource(worldName);
            });
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to load world on startup");
            this.getLogger().warning(e.toString());
        }
    }

    public void onDisable() {
        this.getLogger().info("Clearing temp directory");
        Path pluginFolder = Path.of(this.getDataFolder().getAbsolutePath(), new String[0]);
        Path tempFolder = pluginFolder.resolve("temp");
        if (Files.exists(tempFolder, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(tempFolder, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to delete temp directory");
                this.getLogger().log(Level.INFO, e.getMessage(), e);
            }
        } else {
            this.getLogger().log(Level.INFO, "Temp directory does not exist. Skipping...");
        }
        for (World world : this.getServer().getWorlds()) {
            PolarWorld polarWorld = PolarWorld.fromWorld(world);
            PolarGenerator generator = PolarGenerator.fromWorld(world);
            if (polarWorld == null || generator == null) continue;
            if (!generator.getConfig().saveOnStop()) {
                PolarPaper.logger().info(String.format("Not saving '%s' as it has save on stop disabled", world.getName()));
                return;
            }
            this.getLogger().info("Saving '" + world.getName() + "'...");
            long before = System.nanoTime();
            Path worldsFolder = pluginFolder.resolve("worlds");
            Path path = worldsFolder.resolve(world.getName() + ".polar");
            Polar.saveWorldSync(world, polarWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, new FilePolarSource(path), ChunkSelector.all(), 0, 0);
            int ms = (int)((System.nanoTime() - before) / 1000000L);
            PolarPaper.logger().info(String.format("Saved '%s' in %sms", world.getName(), ms));
        }
    }

    public static PolarPaper getPlugin() {
        return (PolarPaper)PolarPaper.getPlugin(PolarPaper.class);
    }

    public static Logger logger() {
        return PolarPaper.getPlugin().getLogger();
    }

    public static void registerEvents() {
        PolarPaper.getPlugin().getServer().getPluginManager().registerEvents((Listener)new PolarListener(), (Plugin)PolarPaper.getPlugin());
    }
}

