/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.generator.ChunkGenerator;

public class PolarListener
implements Listener {
    @EventHandler
    public void onChunkPopulate(ChunkPopulateEvent event) {
        PolarWorld polarWorld = PolarWorld.fromWorld(event.getWorld());
        if (polarWorld == null) {
            return;
        }
        PolarChunk chunk = polarWorld.chunkAt(event.getChunk().getX(), event.getChunk().getZ());
        if (chunk == null) {
            return;
        }
        ChunkGenerator generator = event.getWorld().getGenerator();
        if (!(generator instanceof PolarGenerator)) {
            return;
        }
        PolarGenerator polarGenerator = (PolarGenerator)generator;
        PolarWorldAccess worldAccess = polarGenerator.getWorldAccess();
        if (chunk.userData().length > 0) {
            worldAccess.populateChunkData(event.getChunk(), chunk.userData());
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("coralDeath", false);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("liquidPhysics", false);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("blockPhysics", false);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onChangeBlock(EntityChangeBlockEvent event) {
        if (!event.getBlock().getType().hasGravity()) {
            return;
        }
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("blockPhysics", false);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }
}

