/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.util.CoordConversion;
import net.kyori.adventure.key.Key;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;

public class PolarBiomeProvider
extends BiomeProvider {
    @NotNull
    private final PolarWorld polarWorld;

    public PolarBiomeProvider(@NotNull PolarWorld polarWorld) {
        this.polarWorld = polarWorld;
    }

    @NotNull
    public Biome getBiome(@NotNull WorldInfo worldInfo, int x, int y, int z) {
        int chunkX = CoordConversion.globalToChunk(x);
        int chunkZ = CoordConversion.globalToChunk(z);
        Biome defaultBiome = switch (worldInfo.getEnvironment()) {
            default -> throw new MatchException(null, null);
            case World.Environment.NORMAL, World.Environment.CUSTOM -> Biome.PLAINS;
            case World.Environment.NETHER -> Biome.NETHER_WASTES;
            case World.Environment.THE_END -> Biome.THE_END;
        };
        PolarChunk chunk = this.polarWorld.chunkAt(chunkX, chunkZ);
        if (chunk == null) {
            return defaultBiome;
        }
        int sectionIndex = CoordConversion.sectionIndex(y, this.polarWorld.minSection());
        if (sectionIndex < 0) {
            return defaultBiome;
        }
        if (sectionIndex >= chunk.sections().length) {
            return defaultBiome;
        }
        PolarSection section = chunk.sections()[sectionIndex];
        String[] rawBiomePalette = section.biomePalette();
        if (rawBiomePalette.length == 1) {
            return this.parseBiome(rawBiomePalette[0]);
        }
        int localX = CoordConversion.globalToSectionRelative(x);
        int localY = CoordConversion.globalToSectionRelative(y);
        int localZ = CoordConversion.globalToSectionRelative(z);
        int index = localX / 4 + localZ / 4 * 4 + localY / 4 * 16;
        int[] biomeDataArray = section.biomeData();
        int biomeData = biomeDataArray[index];
        return this.parseBiome(rawBiomePalette[biomeData]);
    }

    @NotNull
    public List<Biome> getBiomes(@NotNull WorldInfo worldInfo) {
        Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME);
        return registry.stream().toList();
    }

    private Biome parseBiome(String s) {
        Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME);
        try {
            return (Biome)registry.get(Key.key((String)s));
        }
        catch (IllegalArgumentException e) {
            PolarPaper.logger().warning("Failed to parse biome " + s);
            return Biome.PLAINS;
        }
    }
}

