/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import live.minehub.polarpaper.PolarPaper;
import net.minecraft.world.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public record Config(@NotNull String source, int autoSaveIntervalTicks, boolean saveOnStop, boolean loadOnStartup, @NotNull Location spawn, @NotNull Difficulty difficulty, boolean allowMonsters, boolean allowAnimals, boolean allowWorldExpansion, @NotNull WorldType worldType, @NotNull World.Environment environment, @NotNull Map<String, Object> gamerules) {
    public static final Config DEFAULT = new Config("file", -1, false, true, new Location(null, 0.0, 64.0, 0.0), Difficulty.NORMAL, true, true, true, WorldType.NORMAL, World.Environment.NORMAL, Map.of("doMobSpawning", false, "doFireTick", false, "randomTickSpeed", 0, "mobGriefing", false, "doVinesSpread", false, "pvp", true, "coralDeath", false, "blockPhysics", false, "liquidPhysics", false));

    @NotNull
    public static Config getDefaultConfig(World world) {
        HashMap<String, Object> gameruleMap = new HashMap<String, Object>(DEFAULT.gamerules());
        for (String name : world.getGameRules()) {
            Object gameRuleDefault;
            Object gameRuleValue;
            GameRule gamerule = GameRule.getByName((String)name);
            if (gamerule == null || (gameRuleValue = world.getGameRuleValue(gamerule)) == null || gameRuleValue == (gameRuleDefault = world.getGameRuleDefault(gamerule))) continue;
            gameruleMap.put(name, gameRuleValue);
        }
        return new Config("file", -1, Config.DEFAULT.saveOnStop, Config.DEFAULT.loadOnStartup, world.getSpawnLocation(), Difficulty.valueOf((String)world.getDifficulty().name()), world.getAllowMonsters(), world.getAllowAnimals(), Config.DEFAULT.allowWorldExpansion, WorldType.NORMAL, world.getEnvironment(), gameruleMap);
    }

    @NotNull
    public String spawnString() {
        return Config.locationToString(this.spawn());
    }

    @NotNull
    public Config withSpawnPos(Location location) {
        return new Config(this.source, this.autoSaveIntervalTicks, this.saveOnStop, this.loadOnStartup, location, this.difficulty, this.allowMonsters, this.allowAnimals, this.allowWorldExpansion, this.worldType, this.environment, this.gamerules);
    }

    @NotNull
    public static Config readFromConfig(FileConfiguration config, String worldName) {
        return Config.readFromConfig(config, worldName, DEFAULT);
    }

    @NotNull
    public static Config readFromConfig(FileConfiguration config, String worldName, Config defaultConfig) {
        String prefix = String.format("worlds.%s.", worldName);
        try {
            String source = config.getString(prefix + "source", defaultConfig.source);
            int autoSaveIntervalTicks = config.getInt(prefix + "autosaveIntervalTicks", defaultConfig.autoSaveIntervalTicks);
            boolean saveOnStop = config.getBoolean(prefix + "saveOnStop", defaultConfig.saveOnStop);
            boolean loadOnStartup = config.getBoolean(prefix + "loadOnStartup", defaultConfig.loadOnStartup);
            String spawn = config.getString(prefix + "spawn", Config.locationToString(defaultConfig.spawn));
            Difficulty difficulty = Difficulty.valueOf((String)config.getString(prefix + "difficulty", defaultConfig.difficulty.name()));
            boolean allowMonsters = config.getBoolean(prefix + "allowMonsters", defaultConfig.allowMonsters);
            boolean allowAnimals = config.getBoolean(prefix + "allowAnimals", defaultConfig.allowAnimals);
            boolean allowWorldExpansion = config.getBoolean(prefix + "allowWorldExpansion", defaultConfig.allowWorldExpansion);
            WorldType worldType = WorldType.valueOf((String)config.getString(prefix + "worldType", defaultConfig.worldType.name()));
            World.Environment environment = World.Environment.valueOf((String)config.getString(prefix + "environment", defaultConfig.environment.name()));
            List gamerules = config.getMapList(prefix + "gamerules");
            Map<String, Object> gamerulesMap = Config.convertYmlGamerules(gamerules);
            if (gamerules.isEmpty()) {
                gamerulesMap.putAll(defaultConfig.gamerules);
            }
            return new Config(source, autoSaveIntervalTicks, saveOnStop, loadOnStartup, Config.stringToLocation(spawn), difficulty, allowMonsters, allowAnimals, allowWorldExpansion, worldType, environment, gamerulesMap);
        }
        catch (IllegalArgumentException e) {
            PolarPaper.logger().warning("Failed to read config, using defaults");
            PolarPaper.logger().log(Level.INFO, e.getMessage(), e);
            return defaultConfig;
        }
    }

    public static void writeToConfig(FileConfiguration fileConfig, String worldName, Config config) {
        String prefix = String.format("worlds.%s.", worldName);
        fileConfig.set(prefix + "source", (Object)config.source);
        fileConfig.set(prefix + "autosaveIntervalTicks", (Object)config.autoSaveIntervalTicks);
        fileConfig.setInlineComments(prefix + "autosaveIntervalTicks", List.of("-1 to disable"));
        fileConfig.set(prefix + "saveOnStop", (Object)config.saveOnStop);
        fileConfig.set(prefix + "loadOnStartup", (Object)config.loadOnStartup);
        fileConfig.set(prefix + "spawn", (Object)Config.locationToString(config.spawn));
        fileConfig.set(prefix + "difficulty", (Object)config.difficulty.name());
        fileConfig.set(prefix + "allowMonsters", (Object)config.allowMonsters);
        fileConfig.set(prefix + "allowAnimals", (Object)config.allowAnimals);
        fileConfig.set(prefix + "allowWorldExpansion", (Object)config.allowWorldExpansion);
        fileConfig.setInlineComments(prefix + "allowWorldExpansion", List.of("Whether the world can grow and load more chunks"));
        fileConfig.set(prefix + "worldType", (Object)config.worldType.name());
        fileConfig.setInlineComments(prefix + "worldType", List.of("One of: NORMAL, FLAT, AMPLIFIED, LARGE_BIOMES"));
        fileConfig.set(prefix + "environment", (Object)config.environment.name());
        fileConfig.setInlineComments(prefix + "environment", List.of("One of: NORMAL, NETHER, THE_END, CUSTOM"));
        fileConfig.set(prefix + "gamerules", config.gamerulesList());
        fileConfig.setInlineComments(prefix + "gamerules", List.of("Custom rules: liquidPhysics, blockPhysics, coralDeath"));
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path configFile = pluginFolder.resolve("config.yml");
        try {
            fileConfig.save(configFile.toFile());
        }
        catch (IOException e) {
            PolarPaper.logger().warning("Failed to save world to config file");
            PolarPaper.logger().warning(e.toString());
        }
    }

    private static String locationToString(Location spawn) {
        return String.format("%s, %s, %s, %s, %s", spawn.x(), spawn.y(), spawn.z(), Float.valueOf(spawn.getYaw()), Float.valueOf(spawn.getPitch()));
    }

    private static Location stringToLocation(String string) {
        String[] split = string.split(",");
        try {
            if (split.length == 3) {
                String x = split[0];
                String y = split[1];
                String z = split[2];
                return new Location(null, Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z));
            }
            if (split.length == 5) {
                String x = split[0];
                String y = split[1];
                String z = split[2];
                String yaw = split[3];
                String pitch = split[4];
                return new Location(null, Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z), Float.parseFloat(yaw), Float.parseFloat(pitch));
            }
            PolarPaper.logger().warning("Failed to parse spawn pos: " + string);
            return Config.DEFAULT.spawn;
        }
        catch (Exception e) {
            PolarPaper.logger().warning("Failed to parse spawn pos: " + string);
            return Config.DEFAULT.spawn;
        }
    }

    @NotNull
    public List<Map<String, ?>> gamerulesList() {
        ArrayList gamerules = new ArrayList();
        for (Map.Entry<String, Object> entry : this.gamerules().entrySet()) {
            gamerules.add(Map.of(entry.getKey(), entry.getValue()));
        }
        return gamerules;
    }

    @NotNull
    public static Map<String, Object> convertYmlGamerules(List<Map<?, ?>> ymlGamerules) {
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (Map<?, ?> ymlGamerule : ymlGamerules) {
            for (Map.Entry<?, ?> entry : ymlGamerule.entrySet()) {
                Object obj = entry.getKey();
                if (!(obj instanceof String)) continue;
                String key = (String)obj;
                gamerules.put(key, entry.getValue());
            }
        }
        return gamerules;
    }
}

