/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import org.jetbrains.annotations.NotNull;

public interface ChunkSelector {
    @NotNull
    public static ChunkSelector all() {
        return (x, z) -> true;
    }

    @NotNull
    public static ChunkSelector circle(int radius) {
        return ChunkSelector.circle(0, 0, radius);
    }

    @NotNull
    public static ChunkSelector circle(int centerX, int centerZ, int radius) {
        return (x, z) -> {
            int dx = x - centerX;
            int dz = z - centerZ;
            return dx * dx + dz * dz <= radius * radius;
        };
    }

    @NotNull
    public static ChunkSelector square(int radius) {
        return ChunkSelector.square(0, 0, radius);
    }

    @NotNull
    public static ChunkSelector square(int centerX, int centerZ, int radius) {
        return (x, z) -> {
            long dz;
            long dx = Math.abs(x - centerX);
            return Math.max(dx, dz = (long)Math.abs(z - centerZ)) <= (long)radius;
        };
    }

    public boolean test(int var1, int var2);
}

