/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.util;

import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import live.minehub.polarpaper.PolarChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.joml.Vector3i;

public class BlockUtil {
    public static void setBlockFast(World world, int x, int y, int z, BlockState blockState) {
        int newBlockZ;
        int newBlockY;
        CraftWorld craftWorld = (CraftWorld)world;
        ServerLevel serverLevel = craftWorld.getHandle();
        ChunkHolderManager chunkHolderManager = serverLevel.moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = (int)Math.floor((double)x / 16.0);
        int chunkZ = (int)Math.floor((double)z / 16.0);
        int section = (int)Math.floor((double)y / 16.0);
        NewChunkHolder chunkHolder = chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (chunkHolder == null) {
            return;
        }
        ChunkAccess chunkAccess = chunkHolder.getCurrentChunk();
        if (chunkAccess == null) {
            return;
        }
        int sectionI = section - chunkAccess.getMinSectionY();
        if (sectionI >= chunkAccess.getSections().length) {
            return;
        }
        if (sectionI < 0) {
            return;
        }
        LevelChunkSection levelChunkSection = chunkAccess.getSection(sectionI);
        int newBlockX = x % 16;
        if (newBlockX < 0) {
            newBlockX = 16 + newBlockX;
        }
        if ((newBlockY = y % 16) < 0) {
            newBlockY = 16 + newBlockY;
        }
        if ((newBlockZ = z % 16) < 0) {
            newBlockZ = 16 + newBlockZ;
        }
        levelChunkSection.setBlockState(newBlockX, newBlockY, newBlockZ, blockState);
    }

    public static void setBlockEntity(World world, PolarChunk.BlockEntity blockEntity, Vector3i blockOffset) {
        int chunkZ;
        if (blockEntity.data() == null) {
            return;
        }
        int x = blockOffset.x;
        int y = blockOffset.y;
        int z = blockOffset.z;
        CraftWorld craftWorld = (CraftWorld)world;
        ServerLevel serverLevel = craftWorld.getHandle();
        ChunkHolderManager chunkHolderManager = serverLevel.moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = (int)Math.floor((double)x / 16.0);
        NewChunkHolder chunkHolder = chunkHolderManager.getChunkHolder(chunkX, chunkZ = (int)Math.floor((double)z / 16.0));
        if (chunkHolder == null) {
            return;
        }
        ChunkAccess chunkAccess = chunkHolder.getCurrentChunk();
        if (chunkAccess == null) {
            return;
        }
        blockEntity.data().putInt("x", x);
        blockEntity.data().putInt("y", y);
        blockEntity.data().putInt("z", z);
        RegistryAccess.Frozen registryAccess = ((CraftServer)Bukkit.getServer()).getServer().registryAccess();
        BlockEntity nmsBlockEntity = BlockEntity.loadStatic((BlockPos)new BlockPos(x, y, z), (BlockState)chunkAccess.getBlockState(x, y, z), (CompoundTag)blockEntity.data(), (HolderLookup.Provider)registryAccess);
        if (nmsBlockEntity == null) {
            return;
        }
        serverLevel.getChunk(chunkX, chunkZ).addAndRegisterBlockEntity(nmsBlockEntity);
    }
}

